package com.atlassian.crowd.model.cluster;

import java.util.Objects;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.google.common.base.MoreObjects;

public class ClusterLockEntity {
    private String lockName;
    private long timestamp;

    @Nullable
    private String nodeId;

    protected ClusterLockEntity() {
    }

    public ClusterLockEntity(@Nonnull String lockName, @Nullable String nodeId, long timestamp) {
        this.lockName = lockName;
        this.timestamp = timestamp;
        this.nodeId = nodeId;
    }

    public String getLockName() {
        return lockName;
    }

    public void setLockName(String lockName) {
        this.lockName = lockName;
    }

    public long getTimestamp() {
        return timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public String getNodeId() {
        return nodeId;
    }

    public void setNodeId(String nodeId) {
        this.nodeId = nodeId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ClusterLockEntity that = (ClusterLockEntity) o;
        return timestamp == that.timestamp &&
                Objects.equals(lockName, that.lockName) &&
                Objects.equals(nodeId, that.nodeId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(lockName, timestamp, nodeId);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("lockName", lockName)
                .add("timestamp", timestamp)
                .add("nodeId", nodeId)
                .toString();
    }
}