package com.atlassian.crowd.model.application;

import java.io.Serializable;
import java.util.Objects;

public class InternalApplicationDefaultGroupMembershipConfiguration implements Serializable, ApplicationDefaultGroupMembershipConfiguration {

    private Long id;
    private DirectoryMapping directoryMapping;
    private String groupName;

    public InternalApplicationDefaultGroupMembershipConfiguration() {
    }

    public InternalApplicationDefaultGroupMembershipConfiguration(DirectoryMapping directoryMapping, String groupName) {
        this(null, directoryMapping, groupName);
    }

    public InternalApplicationDefaultGroupMembershipConfiguration(Long id, DirectoryMapping directoryMapping, String groupName) {
        this.id = id;
        this.directoryMapping = directoryMapping;
        this.groupName = groupName;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public DirectoryMapping getDirectoryMapping() {
        return directoryMapping;
    }

    public void setDirectoryMapping(DirectoryMapping directoryMapping) {
        this.directoryMapping = directoryMapping;
    }

    public String getGroupName() {
        return groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InternalApplicationDefaultGroupMembershipConfiguration)) {
            return false;
        }

        InternalApplicationDefaultGroupMembershipConfiguration that = (InternalApplicationDefaultGroupMembershipConfiguration) o;

        if (directoryMapping != null
                && that.directoryMapping != null) {
            if (!Objects.equals(directoryMapping.getId(), that.directoryMapping.getId())) {
                return false;
            }
        } else if (directoryMapping != that.directoryMapping) {
            return false;
        }

        return Objects.equals(groupName, that.groupName);
    }

    @Override
    public int hashCode() {
        return Objects.hash(directoryMapping == null ? 0 : directoryMapping.getId(), groupName);
    }
}
