package com.atlassian.crowd.model;

import com.atlassian.crowd.attribute.AttributeUtil;
import com.atlassian.crowd.embedded.api.Attributes;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import org.apache.commons.lang3.builder.ToStringBuilder;

import java.util.Map;
import java.util.Set;

/**
 * Base class for any entity that can have attributes.
 */
public abstract class EntityWithAttributes implements Attributes {
    private final ImmutableSetMultimap<String, String> attributes;

    public EntityWithAttributes(final Multimap<String, String> attributes) {
        this.attributes = ImmutableSetMultimap.copyOf(attributes);
    }

    public EntityWithAttributes(final Map<String, Set<String>> attributes) {
        this(AttributeUtil.toMultimap(attributes));
    }

    public Set<String> getValues(String name) {
        return attributes.get(name);
    }

    public String getValue(String name) {
        return Iterables.getFirst(getValues(name), null);
    }

    public boolean isEmpty() {
        return attributes.isEmpty();
    }

    public Set<String> getKeys() {
        return attributes.keySet();
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this).
                append("attributes", attributes).
                toString();
    }
}
