package com.atlassian.crowd.directory;

import com.atlassian.crowd.embedded.api.PasswordConstraint;
import com.atlassian.crowd.embedded.api.ValidatePasswordRequest;

import static com.google.common.base.Preconditions.checkArgument;

public class PasswordLengthConstraint implements PasswordConstraint {
    private final int minimumLength;

    /**
     * @param minimumLength The minimum length of a password. Must be at least zero.
     */
    public PasswordLengthConstraint(int minimumLength) {
        checkArgument(minimumLength >= 0);
        this.minimumLength = minimumLength;
    }

    public int getMinimumLength() {
        return minimumLength;
    }

    @Override
    public String toString() {
        return "PasswordLengthConstraint(minimum=" + minimumLength + ")";
    }

    @Override
    public boolean validate(ValidatePasswordRequest request) {
        return request.getPassword().getCredential().length() >= minimumLength;
    }
}
