package com.atlassian.crowd.directory;

import java.util.Set;

import com.atlassian.crowd.embedded.api.Attributes;
import com.atlassian.crowd.embedded.api.PasswordConstraint;

/**
 * Has the responsibility of instantiating the active {@link com.atlassian.crowd.embedded.api.PasswordConstraint}'s
 * for a directory.
 */
public interface PasswordConstraintsLoader {
    /**
     * Returns all constraints that are configured for a directory.
     *
     * @param directoryId a directory's id
     * @param attributes  a directory's Attributes
     * @return a set of {@link com.atlassian.crowd.embedded.api.PasswordConstraint}'s
     */
    Set<PasswordConstraint> getFromDirectoryAttributes(long directoryId, Attributes attributes);

}
