package com.atlassian.crowd.dao.licensing;

import com.atlassian.crowd.exception.ObjectNotFoundException;
import com.atlassian.crowd.model.application.Application;
import com.atlassian.crowd.model.ApplicationSubtype;
import com.atlassian.crowd.model.licensing.LicensingSummary;

import java.util.List;
import java.util.Optional;

/**
 * Data access object for {@link LicensingSummary}
 */
public interface LicensingSummaryDao {
    LicensingSummary findById(Long id) throws ObjectNotFoundException;

    Optional<LicensingSummary> getLicensingSummaryByVersion(Application application, ApplicationSubtype applicationSubtype, long version);

    Optional<LicensingSummary> findByApplication(Application application, ApplicationSubtype applicationSubtype);

    Optional<LicensingSummary> getLatestLicensingSummary(Application application);

    List<LicensingSummary> findByApplication(Application application, Long version);

    void saveAfterCleanup(LicensingSummary licensingSummary);

    /**
     * Marks current version as an active one and deletes all other versions.
     */
    void activate(LicensingSummary licensingSummary);

    void removeByApplicationId(Long id);
}
