package com.atlassian.crowd.dao.licensing;

import com.atlassian.crowd.model.licensing.DirectoryInfo;
import com.atlassian.crowd.model.licensing.LicensingSummary;
import com.google.common.base.MoreObjects;

import javax.annotation.Nullable;
import java.util.Date;
import java.util.Objects;
import java.util.Optional;

/**
 * Defines constraints for the search query.
 */
public class LicensedUsersQuery {
    private LicensingSummary licensingSummary;
    @Nullable
    private String textSearch;
    @Nullable
    private Date lastActiveOnOrBefore;
    private boolean neverLoggedIn;
    @Nullable
    private DirectoryInfo directoryInfo;
    private int start = 0;
    private int limit = -1;

// The code below has been generated by BoB the Builder of Beans based on the class' fields.
// Everything after this comment will be regenerated if you invoke BoB again.
// If you don't know who BoB is, you can find him here: https://bitbucket.org/atlassianlabs/bob-the-builder-of-beans


    protected LicensedUsersQuery(LicensingSummary licensingSummary, @Nullable String textSearch, @Nullable Date lastActiveOnOrBefore, boolean neverLoggedIn, @Nullable DirectoryInfo directoryInfo, int start, int limit) {
        this.licensingSummary = Objects.requireNonNull(licensingSummary);
        this.textSearch = textSearch;
        this.lastActiveOnOrBefore = lastActiveOnOrBefore;
        this.directoryInfo = directoryInfo;
        this.neverLoggedIn = neverLoggedIn;
        this.start = start;
        this.limit = limit;
    }

    public LicensingSummary getLicensingSummary() {
        return licensingSummary;
    }

    public void setLicensingSummary(LicensingSummary licensingSummary) {
        this.licensingSummary = Objects.requireNonNull(licensingSummary);
    }

    public String getTextSearch() {
        return textSearch;
    }

    public boolean isNeverLoggedIn() {
        return neverLoggedIn;
    }

    public void setTextSearch(@Nullable String textSearch) {
        this.textSearch = textSearch;
    }

    public Optional<Date> getLastActiveOnOrBefore() {
        return Optional.ofNullable(lastActiveOnOrBefore);
    }

    public void setLastActiveOnOrBefore(@Nullable Date lastActiveOnOrBefore) {
        this.lastActiveOnOrBefore = lastActiveOnOrBefore;
    }

    public Optional<DirectoryInfo> getDirectoryInfo() {
        return Optional.ofNullable(directoryInfo);
    }

    public void setDirectoryInfo(@Nullable DirectoryInfo directoryInfo) {
        this.directoryInfo = directoryInfo;
    }

    public int getStart() {
        return start;
    }

    public void setStart(int start) {
        this.start = start;
    }

    public int getLimit() {
        return limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public static LicensedUsersQuery.Builder builder() {
        return new LicensedUsersQuery.Builder();
    }

    public static LicensedUsersQuery.Builder builder(LicensedUsersQuery data) {
        return new LicensedUsersQuery.Builder(data);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        LicensedUsersQuery that = (LicensedUsersQuery) o;

        return Objects.equals(this.getLicensingSummary(), that.getLicensingSummary()) && Objects.equals(this.getTextSearch(), that.getTextSearch()) && Objects.equals(this.getLastActiveOnOrBefore(), that.getLastActiveOnOrBefore()) && Objects.equals(this.getDirectoryInfo(), that.getDirectoryInfo()) && Objects.equals(this.getStart(), that.getStart()) && Objects.equals(this.getLimit(), that.getLimit());
    }

    @Override
    public int hashCode() {
        return Objects.hash(getLicensingSummary(), getTextSearch(), getLastActiveOnOrBefore(), getDirectoryInfo(), getStart(), getLimit());
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("licensingSummary", getLicensingSummary())
                .add("textSearch", getTextSearch())
                .add("lastActiveOnOrBefore", getLastActiveOnOrBefore())
                .add("directoryInfo", getDirectoryInfo())
                .add("start", getStart())
                .add("limit", getLimit())
                .toString();
    }

    public static final class Builder {

        private LicensingSummary licensingSummary;
        private String textSearch;
        private Date lastActiveOnOrBefore;
        private DirectoryInfo directoryInfo;
        private boolean neverLoggedIn;
        private int start;
        private int limit;

        private Builder() {
        }

        private Builder(LicensedUsersQuery initialData) {
            this.licensingSummary = initialData.getLicensingSummary();
            this.textSearch = initialData.getTextSearch();
            this.lastActiveOnOrBefore = initialData.getLastActiveOnOrBefore().orElse(null);
            this.directoryInfo = initialData.getDirectoryInfo().orElse(null);
            this.start = initialData.getStart();
            this.limit = initialData.getLimit();
        }

        public Builder setLicensingSummary(LicensingSummary licensingSummary) {
            this.licensingSummary = licensingSummary;
            return this;
        }

        public Builder setTextSearch(@Nullable String textSearch) {
            this.textSearch = textSearch;
            return this;
        }

        public Builder setNeverLoggedIn(boolean neverLoggedIn) {
            this.neverLoggedIn = neverLoggedIn;
            return this;
        }

        public Builder setLastActiveOnOrBefore(@Nullable Date lastActiveOnOrBefore) {
            this.lastActiveOnOrBefore = lastActiveOnOrBefore;
            return this;
        }

        public Builder setDirectoryInfo(@Nullable DirectoryInfo directoryInfo) {
            this.directoryInfo = directoryInfo;
            return this;
        }

        public Builder setStart(int start) {
            this.start = start;
            return this;
        }

        public Builder setLimit(int limit) {
            this.limit = limit;
            return this;
        }

        public LicensedUsersQuery build() {
            return new LicensedUsersQuery(licensingSummary, textSearch, lastActiveOnOrBefore, neverLoggedIn, directoryInfo, start, limit);
        }
    }
}
