package com.atlassian.crowd.dao.licensing;

import com.atlassian.crowd.exception.ObjectNotFoundException;
import com.atlassian.crowd.model.licensing.DirectoryInfo;
import com.atlassian.crowd.model.licensing.LicensingSummary;

import java.util.List;

/**
 * Data access object for {@link com.atlassian.crowd.model.licensing.DirectoryInfo}
 */
public interface DirectoryInfoDao {
    DirectoryInfo findById(long id) throws ObjectNotFoundException;

    void saveOrUpdate(DirectoryInfo directoryInfo);

    List<DirectoryInfo> findDirectories(LicensingSummary licensingSummary);

    void removeAll(LicensingSummary licensingSummary);

    void removeByDirectoryId(Long id);
}
