package com.atlassian.crowd.dao.cluster;

import java.util.List;

import com.atlassian.crowd.model.cluster.InternalClusterMessage;

/**
 * Persistent storage of messages passed between cluster nodes. Uses message ID to establish chronology.
 */
public interface ClusterMessageDao {
    void addMessage(InternalClusterMessage message);

    /**
     * Fetches messages with ID higher than the specified threshold.
     *
     * @param excludeNodeId node that should be excluded from search (this will usually be the calling node); null to include all nodes
     * @param fromId        start message ID for the search, non-inclusive
     * @return list of results in ascending ID order
     */
    List<InternalClusterMessage> getMessagesAfter(String excludeNodeId, long fromId);

    /**
     * Deletes all mesages older than the timestamp.
     *
     * @param toTimestamp
     * @return number of messages deleted
     */
    int deleteClusterMessagesBeforeAndOn(long toTimestamp);

    /**
     * Finds the highest ID currently in database.
     *
     * @return highest ID found, or null if there are no rows
     */
    Long getHighestId();
}
