package com.atlassian.crowd.dao.audit;

import com.atlassian.crowd.audit.query.AuditLogQuery;
import com.atlassian.crowd.model.audit.AuditLogChangesetEntity;

import java.util.List;

/**
 * Hibernate DAO for storing and accessing the audit log
 */
public interface AuditDao {

    /**
     * Persists the changeset and its entries
     *
     * @param changeset the changeset to persist
     */
    void add(AuditLogChangesetEntity changeset);

    /**
     * Searches the audit log for entries matching the specified criteria
     *
     * @param query the search criteria
     * @return a list of changesets with entries matching the criteria
     */
    <RESULT> List<RESULT> search(AuditLogQuery<RESULT> query);

    /**
     * Removes the audit log entries older than specified timestamp
     *
     * @param timestamp the timestamp
     * @return number of deleted entities
     */
    int removeChangesetsOlderThan(long timestamp);

    /**
     * @return the amount of changesets in the audit log
     */
    long getAuditLogSize();
}
