/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.dao.token;

import com.atlassian.crowd.dao.token.TokenDAO;
import com.atlassian.crowd.dao.token.TokenDAOSearchUtils;
import com.atlassian.crowd.exception.ObjectNotFoundException;
import com.atlassian.crowd.manager.cache.CacheManager;
import com.atlassian.crowd.manager.cache.CacheManagerException;
import com.atlassian.crowd.manager.cache.NotInCacheException;
import com.atlassian.crowd.model.token.Token;
import com.atlassian.crowd.model.token.TokenLifetime;
import com.atlassian.crowd.search.Entity;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.util.SearchResultsUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataRetrievalFailureException;

public class TokenDAOMemory
implements TokenDAO {
    public static final String RANDOM_HASH_CACHE = Token.class.getName() + ".random-hash-cache";
    public static final String IDENTIFIER_HASH_CACHE;
    @Deprecated
    public static final String IDENTIFIER_HASH_CAHE;
    private static final Logger logger;
    private CacheManager cacheManager;

    @Override
    public Token findByRandomHash(String randomHash) throws ObjectNotFoundException {
        Token token = null;
        try {
            token = (Token)this.cacheManager.get(RANDOM_HASH_CACHE, (Serializable)((Object)randomHash));
        }
        catch (CacheManagerException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (NotInCacheException e) {
            throw new ObjectNotFoundException(this.getPersistentClass(), (Object)randomHash);
        }
        return token;
    }

    @Override
    public Token findByIdentifierHash(String identifierHash) throws ObjectNotFoundException {
        Token token = null;
        try {
            token = (Token)this.cacheManager.get(IDENTIFIER_HASH_CACHE, (Serializable)((Object)identifierHash));
        }
        catch (CacheManagerException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (NotInCacheException e) {
            throw new ObjectNotFoundException(this.getPersistentClass(), (Object)identifierHash);
        }
        return token;
    }

    @Override
    public Token add(Token token) {
        try {
            this.cacheManager.put(RANDOM_HASH_CACHE, (Serializable)((Object)token.getRandomHash()), (Serializable)token);
            this.cacheManager.put(IDENTIFIER_HASH_CACHE, (Serializable)((Object)token.getIdentifierHash()), (Serializable)token);
        }
        catch (CacheManagerException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return token;
    }

    @Override
    public Token update(Token token) {
        token.setLastAccessedTime(System.currentTimeMillis());
        return this.add(token);
    }

    @Override
    public void remove(Token token) {
        try {
            this.cacheManager.remove(RANDOM_HASH_CACHE, (Serializable)((Object)token.getRandomHash()));
            this.cacheManager.remove(IDENTIFIER_HASH_CACHE, (Serializable)((Object)token.getIdentifierHash()));
        }
        catch (CacheManagerException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public List<Token> search(EntityQuery<? extends Token> query) {
        if (query.getEntityDescriptor().getEntityType() != Entity.TOKEN) {
            throw new IllegalArgumentException("TokenDAO can only evaluate EntityQueries for Entity.TOKEN");
        }
        ArrayList<Token> tokens = new ArrayList();
        List<String> keys = this.findRandomHashKeys();
        for (String key : keys) {
            try {
                Token token = this.findByRandomHash(key);
                if (!TokenDAOSearchUtils.tokenMatchesSearchRestriction(token, query.getSearchRestriction())) continue;
                tokens.add(token);
            }
            catch (ObjectNotFoundException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        tokens = SearchResultsUtil.constrainResults(tokens, (int)query.getStartIndex(), (int)query.getMaxResults());
        return tokens;
    }

    private List<String> findRandomHashKeys() {
        return this.cacheManager.getAllKeys(RANDOM_HASH_CACHE);
    }

    @Override
    public void remove(long directoryId, String name) {
        List<String> keys = this.findRandomHashKeys();
        for (String key : keys) {
            try {
                Token token = this.findByRandomHash(key);
                if (token.getDirectoryId() != directoryId || !token.getName().equals(name)) continue;
                this.remove(token);
            }
            catch (ObjectNotFoundException e) {}
        }
    }

    @Override
    public void removeAll(long directoryId) {
        List<String> keys = this.findRandomHashKeys();
        for (String key : keys) {
            try {
                Token token = this.findByRandomHash(key);
                if (token.getDirectoryId() != directoryId) continue;
                this.remove(token);
            }
            catch (ObjectNotFoundException e) {}
        }
    }

    @Override
    public void removeExpiredTokens(Date currentTime, long maxLifeInSeconds) {
        List<String> keys = this.findRandomHashKeys();
        for (String key : keys) {
            try {
                Token token = this.findByRandomHash(key);
                long effectiveTokenSessionTime = this.getEffectiveTokenSessionTime(token, maxLifeInSeconds);
                Date expiryTime = new Date(token.getLastAccessedTime() + TimeUnit.SECONDS.toMillis(effectiveTokenSessionTime));
                if (!expiryTime.before(currentTime)) continue;
                this.remove(token);
            }
            catch (ObjectNotFoundException e) {}
        }
    }

    private long getEffectiveTokenSessionTime(Token token, long defaultMaxLifeInSeconds) {
        TokenLifetime tokenLifetime = token.getLifetime();
        if (tokenLifetime.isDefault()) {
            return defaultMaxLifeInSeconds;
        }
        return Math.min(tokenLifetime.getSeconds(), defaultMaxLifeInSeconds);
    }

    public Class<Token> getPersistentClass() {
        return Token.class;
    }

    public void save(Object persistentObject) {
        this.add((Token)persistentObject);
    }

    public void update(Object persistentObject) {
        this.update((Token)persistentObject);
    }

    public void remove(Object persistentObject) {
        this.remove((Token)persistentObject);
    }

    public Object load(long ID) {
        throw new UnsupportedOperationException("Currently we cannot load Tokens by ID");
    }

    @Override
    public Collection<Token> loadAll() {
        List<String> keys = this.findRandomHashKeys();
        ArrayList<Token> tokens = new ArrayList<Token>(keys.size());
        for (String key : keys) {
            try {
                Token token = this.findByRandomHash(key);
                tokens.add(token);
            }
            catch (ObjectNotFoundException e) {}
        }
        return tokens;
    }

    @Override
    public void saveAll(Collection<Token> tokens) {
        if (tokens == null) {
            throw new DataRetrievalFailureException("Unable to save an empty collection of tokens");
        }
        for (Token token : tokens) {
            this.save(token);
        }
    }

    @Override
    public void removeAll() {
        this.cacheManager.removeAll(RANDOM_HASH_CACHE);
        this.cacheManager.removeAll(IDENTIFIER_HASH_CACHE);
    }

    public void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    static {
        IDENTIFIER_HASH_CAHE = IDENTIFIER_HASH_CACHE = Token.class.getName() + ".identifier-hash-cache";
        logger = LoggerFactory.getLogger(TokenDAOMemory.class);
    }
}

