/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.migration.legacy.database;

import com.atlassian.config.ConfigurationException;
import com.atlassian.crowd.manager.bootstrap.CrowdBootstrapManager;
import com.atlassian.crowd.migration.ImportException;
import com.atlassian.crowd.migration.legacy.LegacyImportDataHolder;
import com.atlassian.crowd.migration.legacy.database.DatabaseImporter;
import com.atlassian.crowd.migration.legacy.database.DatabaseMapper;
import com.atlassian.crowd.model.property.Property;
import com.atlassian.crowd.model.property.PropertyDAOHibernate;
import com.atlassian.crowd.util.persistence.hibernate.batch.BatchProcessor;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.hibernate.SessionFactory;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.RowMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyMapper
extends DatabaseMapper
implements DatabaseImporter {
    private final PropertyDAOHibernate propertyDAO;
    private final CrowdBootstrapManager bootstrapManager;

    public PropertyMapper(SessionFactory sessionFactory, BatchProcessor batchProcessor, JdbcOperations jdbcTemplate, PropertyDAOHibernate propertyDAO, CrowdBootstrapManager bootstrapManager) {
        super(sessionFactory, batchProcessor, jdbcTemplate);
        this.propertyDAO = propertyDAO;
        this.bootstrapManager = bootstrapManager;
    }

    @Override
    public void importFromDatabase(LegacyImportDataHolder importData) throws ImportException {
        List<Property> properties = this.importPropertiesFromDatabase();
        for (Property property : properties) {
            this.addEntityViaSave(property);
        }
        this.logger.info((Object)("Successfully migrated " + properties.size() + " properties"));
    }

    protected List<Property> importPropertiesFromDatabase() throws ImportException {
        ArrayList<Property> properties = new ArrayList<Property>();
        PropertyTableMapper propertyTableMapper = new PropertyTableMapper();
        Map<String, String> propertiesMap = this.attributeListToMap(this.jdbcTemplate.query(this.legacyTableQueries.getPropertiesSQL(), (RowMapper)propertyTableMapper));
        for (Map.Entry<String, String> propertyMap : propertiesMap.entrySet()) {
            String name;
            String codeName = propertyMap.getKey();
            String value = propertyMap.getValue();
            if (codeName.equals("22") && StringUtils.isNotBlank((String)value)) {
                try {
                    this.bootstrapManager.setServerID(value);
                }
                catch (ConfigurationException e) {
                    throw new ImportException((Exception)((Object)e));
                }
            }
            if ((name = this.getNameFromLegacyCode(codeName)) == null) continue;
            Property property = new Property("crowd", name, value);
            properties.add(property);
        }
        return properties;
    }

    private class PropertyTableMapper
    implements RowMapper {
        private PropertyTableMapper() {
        }

        public Object mapRow(ResultSet rs, int rowNum) throws SQLException {
            HashMap<String, String> propertyMap = new HashMap<String, String>();
            String codeName = rs.getString("NAME");
            String value = rs.getString("VALUE");
            propertyMap.put(codeName, value);
            return propertyMap;
        }
    }
}

