/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.migration;

import com.atlassian.config.ConfigurationException;
import com.atlassian.crowd.manager.bootstrap.CrowdBootstrapManager;
import com.atlassian.crowd.migration.ExportException;
import com.atlassian.crowd.migration.ImportException;
import com.atlassian.crowd.migration.Mapper;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class CrowdConfigMapper
implements Mapper {
    protected static final String CONFIG_XML_ROOT = "crowdcfg";
    protected static final String CONFIG_XML_NODE = "property";
    protected static final String CONFIG_XML_NAME = "name";
    protected static final String CONFIG_XML_VALUE = "value";
    protected List<String> propertiesToMap;
    private Logger logger = Logger.getLogger(this.getClass());
    private final CrowdBootstrapManager bootstrapManager;

    public CrowdConfigMapper(CrowdBootstrapManager bootstrapManager) {
        this.bootstrapManager = bootstrapManager;
        this.propertiesToMap = new ArrayList<String>();
        this.propertiesToMap.add("crowd.server.id");
    }

    public Element exportXml(Map options) throws ExportException {
        Element crowdPropertiesRoot = DocumentHelper.createElement((String)CONFIG_XML_ROOT);
        for (String name : this.propertiesToMap) {
            String value = this.bootstrapManager.getString(name);
            if (value != null) {
                Element propertyElement = crowdPropertiesRoot.addElement(CONFIG_XML_NODE);
                propertyElement.addElement(CONFIG_XML_NAME).addText(name);
                propertyElement.addElement(CONFIG_XML_VALUE).addText(value);
                continue;
            }
            this.logger.error((Object)("Failed to find value for property: " + name + " in crowd.cfg.xml"));
        }
        return crowdPropertiesRoot;
    }

    public void importXml(Element root) throws ImportException {
        Element propertiesElement = (Element)root.selectSingleNode("/crowd/ crowdcfg");
        if (propertiesElement == null) {
            this.logger.info((Object)"No config properties were found for importing.");
            return;
        }
        Iterator properties = propertiesElement.elementIterator();
        while (properties.hasNext()) {
            Element propertyElemet = (Element)properties.next();
            String name = propertyElemet.element(CONFIG_XML_NAME).getText();
            String value = propertyElemet.element(CONFIG_XML_VALUE).getText();
            this.bootstrapManager.setProperty(name, (Object)value);
        }
        try {
            this.bootstrapManager.save();
        }
        catch (ConfigurationException e) {
            throw new ImportException((Exception)((Object)e));
        }
    }

    public CrowdBootstrapManager getBootstrapManager() {
        return this.bootstrapManager;
    }
}

