/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.directory.ldap.util;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;

public class GuidHelper {
    public static final String BS = "\\";

    public static String getGUIDAsString(byte[] inArr) {
        StringBuffer guid = new StringBuffer();
        for (int i = 0; i < inArr.length; ++i) {
            StringBuffer dblByte = new StringBuffer(Integer.toHexString(inArr[i] & 0xFF));
            if (dblByte.length() == 1) {
                guid.append("0");
            }
            guid.append(dblByte);
        }
        return guid.toString();
    }

    public static String encodeGUIDForSearch(String guid) {
        Preconditions.checkArgument((guid.length() == 32 ? 1 : 0) != 0, (Object)"guid should be of length 32 (as encoded by getGUIDAsString)");
        StringBuilder sb = new StringBuilder(48);
        sb.append(BS);
        Iterable split = Splitter.fixedLength((int)2).split((CharSequence)guid);
        return Joiner.on((String)BS).appendTo(sb, split).toString();
    }
}

