/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.directory.ldap.monitor.listener;

import com.atlassian.crowd.directory.LDAPDirectory;
import com.atlassian.crowd.directory.ldap.monitor.listener.ChangeListener;
import com.atlassian.crowd.event.remote.principal.RemoteUserCreatedEvent;
import com.atlassian.crowd.event.remote.principal.RemoteUserDeletedEvent;
import com.atlassian.crowd.event.remote.principal.RemoteUserUpdatedEvent;
import com.atlassian.crowd.exception.GroupNotFoundException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.model.user.LDAPUserWithAttributes;
import com.atlassian.crowd.model.user.User;
import com.atlassian.event.api.EventPublisher;
import javax.naming.Name;
import org.springframework.ldap.core.ContextMapper;

public class UserChangeListener
extends ChangeListener {
    public UserChangeListener(LDAPDirectory remoteDirectory, Name baseDN, String objectFilter, ContextMapper mapper, EventPublisher eventPublisher, boolean lookupUpdates) {
        super(remoteDirectory, baseDN, objectFilter, mapper, eventPublisher, lookupUpdates);
    }

    @Override
    protected void publishEntityCreatedEvent(Object entity) {
        this.eventPublisher.publish((Object)new RemoteUserCreatedEvent((Object)this, this.getDirectoryID(), (User)entity));
    }

    @Override
    protected void publishEntityUpdatedEvent(Object entity) {
        this.eventPublisher.publish((Object)new RemoteUserUpdatedEvent((Object)this, this.getDirectoryID(), (User)entity));
    }

    @Override
    protected void publishEntityDeletedEvent(Object entity) {
        this.eventPublisher.publish((Object)new RemoteUserDeletedEvent(this, this.getDirectoryID(), ((User)entity).getName()));
    }

    @Override
    protected Object lookupEntity(String dn) {
        try {
            return this.remoteDirectory.findEntityByDN(dn, LDAPUserWithAttributes.class);
        }
        catch (UserNotFoundException e) {
            return null;
        }
        catch (OperationFailedException e) {
            return null;
        }
        catch (GroupNotFoundException e) {
            throw new AssertionError((Object)"Should not throw GroupNotFoundException");
        }
    }
}

