/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.directory.ldap.cache;

import com.atlassian.crowd.model.LDAPDirectoryEntity;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;

public class LDAPEntityNameMap<T extends LDAPDirectoryEntity> {
    private Map<String, String> guidMap = new HashMap<String, String>();
    private Map<String, String> dnMap = new HashMap<String, String>();

    public void put(T ldapEntity) {
        this.guidMap.put(ldapEntity.getValue("objectGUID"), ldapEntity.getName());
        this.dnMap.put(ldapEntity.getDn(), ldapEntity.getName());
    }

    public String getByDn(String dn) {
        return this.dnMap.get(dn);
    }

    public String getByGuid(String guid) {
        return this.guidMap.get(guid);
    }

    public void clear() {
        this.guidMap.clear();
        this.dnMap.clear();
    }

    public Map<LdapName, String> toLdapNameKeyedMap() throws InvalidNameException {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry<String, String> e : this.dnMap.entrySet()) {
            builder.put((Object)new LdapName(e.getKey()), (Object)e.getValue());
        }
        return builder.build();
    }
}

