/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.directory;

import com.atlassian.crowd.directory.ldap.mapper.ContextMapperWithRequiredAttributes;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Set;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import org.springframework.ldap.core.DirContextAdapter;

class NamedLdapEntity {
    private final LdapName dn;
    private final String name;
    private static final Function<? super NamedLdapEntity, String> NAMES_OF = new Function<NamedLdapEntity, String>(){

        public String apply(NamedLdapEntity input) {
            return input.getName();
        }
    };

    NamedLdapEntity(LdapName dn, String name) {
        this.dn = (LdapName)Preconditions.checkNotNull((Object)dn, (Object)"DN may not be null");
        this.name = name;
    }

    LdapName getDn() {
        return this.dn;
    }

    String getName() {
        return this.name;
    }

    public String toString() {
        return this.dn.toString() + " = " + this.name;
    }

    static Iterable<String> namesOf(Iterable<? extends NamedLdapEntity> namedEntities) {
        return Iterables.transform(namedEntities, NAMES_OF);
    }

    static ContextMapperWithRequiredAttributes<NamedLdapEntity> mapperFromAttribute(String attrName) {
        return new NamedEntityMapper(attrName);
    }

    static class NamedEntityMapper
    implements ContextMapperWithRequiredAttributes<NamedLdapEntity> {
        private final String nameAttribute;

        NamedEntityMapper(String nameAttribute) {
            this.nameAttribute = (String)Preconditions.checkNotNull((Object)nameAttribute, (Object)"Attribute name may not be null");
        }

        @Override
        public NamedLdapEntity mapFromContext(Object ctx) {
            LdapName dn;
            DirContextAdapter context = (DirContextAdapter)ctx;
            try {
                dn = new LdapName(context.getDn().toString());
            }
            catch (InvalidNameException e) {
                throw new RuntimeException(e);
            }
            return new NamedLdapEntity(dn, context.getStringAttribute(this.nameAttribute));
        }

        @Override
        public Set<String> getRequiredLdapAttributes() {
            return ImmutableSet.of((Object)this.nameAttribute);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NamedEntityMapper that = (NamedEntityMapper)o;
            return this.nameAttribute.equals(that.nameAttribute);
        }

        public int hashCode() {
            return this.nameAttribute.hashCode();
        }
    }
}

