/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.directory;

import com.atlassian.crowd.directory.RFC4519Directory;
import com.atlassian.crowd.directory.ldap.control.DeletedResultsControl;
import com.atlassian.crowd.directory.ldap.mapper.ContextMapperWithRequiredAttributes;
import com.atlassian.crowd.directory.ldap.mapper.TombstoneContextMapper;
import com.atlassian.crowd.directory.ldap.mapper.attribute.AttributeMapper;
import com.atlassian.crowd.directory.ldap.mapper.attribute.ObjectGUIDMapper;
import com.atlassian.crowd.directory.ldap.mapper.attribute.USNChangedMapper;
import com.atlassian.crowd.directory.ldap.mapper.attribute.group.RFC4519MemberDnRangeOffsetMapper;
import com.atlassian.crowd.directory.ldap.mapper.attribute.group.RFC4519MemberDnRangedMapper;
import com.atlassian.crowd.directory.ldap.name.GenericConverter;
import com.atlassian.crowd.directory.ldap.util.IncrementalAttributeMapper;
import com.atlassian.crowd.directory.ldap.util.ListAttributeValueProcessor;
import com.atlassian.crowd.directory.ldap.util.RangeOption;
import com.atlassian.crowd.exception.InvalidCredentialException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.model.Tombstone;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.group.GroupTemplateWithAttributes;
import com.atlassian.crowd.model.group.GroupType;
import com.atlassian.crowd.model.group.GroupWithAttributes;
import com.atlassian.crowd.model.group.LDAPGroupWithAttributes;
import com.atlassian.crowd.model.user.LDAPUserWithAttributes;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.search.ldap.LDAPQueryTranslater;
import com.atlassian.crowd.util.InstanceFactory;
import com.atlassian.event.api.EventPublisher;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.SearchControls;
import javax.naming.ldap.LdapName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ldap.NamingException;
import org.springframework.ldap.core.DirContextAdapter;
import org.springframework.ldap.core.DirContextProcessor;
import org.springframework.ldap.filter.AndFilter;
import org.springframework.ldap.filter.EqualsFilter;
import org.springframework.ldap.filter.Filter;
import org.springframework.ldap.filter.GreaterThanOrEqualsFilter;
import org.springframework.ldap.filter.HardcodedFilter;

public class MicrosoftActiveDirectory
extends RFC4519Directory {
    private static final Logger logger = LoggerFactory.getLogger(MicrosoftActiveDirectory.class);
    private static final int UF_ACCOUNTDISABLE = 2;
    private static final int UF_PASSWD_NOTREQD = 32;
    private static final int UF_NORMAL_ACCOUNT = 512;
    private static final int UF_PASSWORD_EXPIRED = 0x800000;
    private static final String AD_USER_ACCOUNT_CONTROL = "userAccountControl";
    private static final String AD_SAM_ACCOUNT_NAME = "samAccountName";
    private static final String AD_PASSWORD_ENCODED = "UTF-16LE";
    private static final String AD_HIGHEST_COMMITTED_USN = "highestCommittedUSN";
    private static final String AD_IS_DELETED = "isDeleted";
    private static final String AD_OBJECT_CLASS = "objectClass";
    private static final String DELETED_OBJECTS_DN_ADDITION = "CN=Deleted Objects";
    private static final String ROOT_DOMAIN_NAMING_CONTEXT = "rootDomainNamingContext";
    private static final String GROUP_TYPE_NAME = "groupType";
    private static final String GROUP_TYPE_VALUE = "2";

    public MicrosoftActiveDirectory(LDAPQueryTranslater ldapQueryTranslater, EventPublisher eventPublisher, InstanceFactory instanceFactory) {
        super(ldapQueryTranslater, eventPublisher, instanceFactory);
    }

    public static String getStaticDirectoryType() {
        return "Microsoft Active Directory";
    }

    public String getDescriptiveName() {
        return MicrosoftActiveDirectory.getStaticDirectoryType();
    }

    @Override
    protected String getInitialGroupMemberDN() {
        return null;
    }

    protected byte[] encodePassword(String unencodedPassword) throws InvalidCredentialException {
        try {
            String newQuotedPassword = "\"" + unencodedPassword + "\"";
            return newQuotedPassword.getBytes(AD_PASSWORD_ENCODED);
        }
        catch (UnsupportedEncodingException e) {
            throw new InvalidCredentialException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    protected void getNewUserDirectorySpecificAttributes(User user, Attributes attributes) {
        attributes.put(AD_SAM_ACCOUNT_NAME, user.getName());
        String accountStatus = null;
        accountStatus = user.isActive() ? Integer.toString(0x800220) : Integer.toString(0x800222);
        attributes.put(new BasicAttribute(AD_USER_ACCOUNT_CONTROL, accountStatus));
    }

    @Override
    protected void getNewGroupDirectorySpecificAttributes(Group group, Attributes attributes) {
        attributes.put(GROUP_TYPE_NAME, GROUP_TYPE_VALUE);
    }

    @Override
    protected List<AttributeMapper> getCustomUserAttributeMappers() {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.addAll(super.getCustomUserAttributeMappers());
        builder.add((Object)new ObjectGUIDMapper());
        builder.add((Object)new USNChangedMapper());
        return builder.build();
    }

    @Override
    protected List<AttributeMapper> getCustomGroupAttributeMappers() {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.addAll(super.getCustomGroupAttributeMappers());
        builder.add((Object)new ObjectGUIDMapper());
        builder.add((Object)new USNChangedMapper());
        return builder.build();
    }

    @Override
    protected List<AttributeMapper> getMemberDnMappers() {
        return Arrays.asList(new RFC4519MemberDnRangedMapper(this.ldapPropertiesMapper.getGroupMemberAttribute(), this.ldapPropertiesMapper.isRelaxedDnStandardisation()), new RFC4519MemberDnRangeOffsetMapper(this.ldapPropertiesMapper.getGroupMemberAttribute()));
    }

    @Override
    protected List<LDAPGroupWithAttributes> postprocessGroups(List<LDAPGroupWithAttributes> groups) throws OperationFailedException {
        ArrayList result = Lists.newArrayList();
        for (LDAPGroupWithAttributes group : groups) {
            if (group.getValue("memberRangeStart") != null) {
                LdapName groupDnName;
                ListAttributeValueProcessor valueAggregator = new ListAttributeValueProcessor();
                String rangeStart = group.getValue("memberRangeStart");
                RangeOption range = new RangeOption(Integer.valueOf(rangeStart));
                IncrementalAttributeMapper incrementalAttributeMapper = new IncrementalAttributeMapper(this.ldapPropertiesMapper.getGroupMemberAttribute(), valueAggregator, range);
                try {
                    groupDnName = new LdapName(group.getDn());
                }
                catch (InvalidNameException e) {
                    throw new OperationFailedException("Unable to parse DN for group", (Throwable)e);
                }
                while (incrementalAttributeMapper.hasMore()) {
                    this.ldapTemplate.lookup(groupDnName, incrementalAttributeMapper.getAttributesArray(), incrementalAttributeMapper);
                }
                Set<String> initialMembers = group.getValues("memberDNs");
                HashSet<String> standardDNs = new HashSet<String>(initialMembers.size() + valueAggregator.getValues().size());
                standardDNs.addAll(initialMembers);
                for (String memberDN : valueAggregator.getValues()) {
                    String dn = this.standardiseDN(memberDN);
                    standardDNs.add(dn);
                }
                GroupTemplateWithAttributes groupTemplate = new GroupTemplateWithAttributes((GroupWithAttributes)group);
                groupTemplate.setAttribute("memberDNs", standardDNs);
                groupTemplate.removeAttribute("memberRangeStart");
                result.add(new LDAPGroupWithAttributes(group.getDn(), groupTemplate));
                continue;
            }
            result.add(group);
        }
        return result;
    }

    @Override
    protected Map<String, String> getBaseEnvironmentProperties() {
        Map<String, String> env = super.getBaseEnvironmentProperties();
        env.put("java.naming.ldap.attributes.binary", "objectGUID");
        return env;
    }

    public long fetchHighestCommittedUSN() throws OperationFailedException {
        try {
            String highestCommittedUSN = ((DirContextAdapter)this.ldapTemplate.lookup(GenericConverter.emptyLdapName())).getStringAttribute(AD_HIGHEST_COMMITTED_USN);
            if (highestCommittedUSN != null) {
                try {
                    long usn = Long.parseLong(highestCommittedUSN);
                    if (logger.isDebugEnabled()) {
                        logger.debug("Fetched highest committed USN of " + usn);
                    }
                    return usn;
                }
                catch (NumberFormatException e) {
                    throw new OperationFailedException("Error parsing highestCommittedUSN as a number", (Throwable)e);
                }
            }
            throw new OperationFailedException("No highestCommittedUSN attribute found for AD root");
        }
        catch (NamingException e) {
            throw new OperationFailedException("Error looking up attributes for highestCommittedUSN", (Throwable)e);
        }
    }

    public List<LDAPUserWithAttributes> findAddedOrUpdatedUsersSince(long usnChange) throws OperationFailedException {
        return this.findAddedOrUpdatedObjectsSince(usnChange, this.searchDN.getUser(), this.ldapPropertiesMapper.getUserFilter(), this.getUserContextMapper());
    }

    public List<LDAPGroupWithAttributes> findAddedOrUpdatedGroupsSince(long usnChanged) throws OperationFailedException {
        return this.findAddedOrUpdatedObjectsSince(usnChanged, this.searchDN.getGroup(), this.ldapPropertiesMapper.getGroupFilter(), this.getGroupContextMapper(GroupType.GROUP));
    }

    public List<Tombstone> findUserTombstonesSince(long usnChange) throws OperationFailedException {
        return this.findTombstonesSince(usnChange, this.searchDN.getUser(), this.ldapPropertiesMapper.getUserObjectClass());
    }

    public List<Tombstone> findGroupTombstonesSince(long usnChange) throws OperationFailedException {
        return this.findTombstonesSince(usnChange, this.searchDN.getGroup(), this.ldapPropertiesMapper.getGroupObjectClass());
    }

    protected <T> List<T> findAddedOrUpdatedObjectsSince(long usnChange, Name objectBaseDN, String objectFilter, ContextMapperWithRequiredAttributes<T> contextMapper) throws OperationFailedException {
        AndFilter filter = new AndFilter();
        filter.and((Filter)new HardcodedFilter(objectFilter));
        filter.and((Filter)new GreaterThanOrEqualsFilter("uSNChanged", Long.toString(usnChange + 1L)));
        logger.debug("Performing polling search: baseDN = " + objectBaseDN + " - filter = " + filter.encode());
        return this.searchEntities(objectBaseDN, filter.encode(), contextMapper, 0, -1);
    }

    private Name getDeletedObjectsDN() {
        try {
            DirContextAdapter root = (DirContextAdapter)this.ldapTemplate.lookup(new LdapName(""));
            String rootDN = root.getStringAttribute(ROOT_DOMAIN_NAMING_CONTEXT);
            String dn = new StringBuffer(DELETED_OBJECTS_DN_ADDITION).append(",").append(rootDN).toString();
            return new LdapName(dn);
        }
        catch (javax.naming.NamingException e) {
            return this.searchDN.getNamingContext();
        }
    }

    protected List<Tombstone> findTombstonesSince(long usnChange, Name objectBaseDN, String objectClass) throws OperationFailedException {
        TombstoneContextMapper contextMapper = new TombstoneContextMapper();
        SearchControls searchControls = this.getSubTreeSearchControls(contextMapper);
        AndFilter filter = new AndFilter();
        filter.and((Filter)new EqualsFilter(AD_IS_DELETED, "TRUE"));
        filter.and((Filter)new EqualsFilter(AD_OBJECT_CLASS, objectClass));
        filter.and((Filter)new GreaterThanOrEqualsFilter("uSNChanged", Long.toString(usnChange + 1L)));
        Name deletedObjectsDN = this.getDeletedObjectsDN();
        logger.debug("Performing tombstones search: baseDN = " + deletedObjectsDN + " - filter = " + filter.encode());
        return this.searchEntitiesWithRequestControls(deletedObjectsDN, filter.encode(), contextMapper, searchControls, (DirContextProcessor)new DeletedResultsControl(), 0, -1);
    }
}

