/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.directory.ldap.monitor.listener;

import com.atlassian.crowd.directory.LDAPDirectory;
import com.atlassian.crowd.event.remote.RemoteDirectoryMonitorErrorEvent;
import com.atlassian.event.api.EventPublisher;
import javax.naming.Name;
import javax.naming.directory.SearchResult;
import javax.naming.event.NamespaceChangeListener;
import javax.naming.event.NamingEvent;
import javax.naming.event.NamingExceptionEvent;
import javax.naming.event.ObjectChangeListener;
import org.apache.log4j.Logger;
import org.springframework.ldap.core.ContextMapper;
import org.springframework.ldap.core.DirContextAdapter;
import org.springframework.ldap.core.DistinguishedName;

public abstract class ChangeListener
implements ObjectChangeListener,
NamespaceChangeListener {
    protected final Logger logger = Logger.getLogger(this.getClass());
    protected final LDAPDirectory remoteDirectory;
    protected final Name baseDN;
    protected final String objectFilter;
    protected final ContextMapper mapper;
    protected final EventPublisher eventPublisher;
    protected final boolean lookupUpdates;

    public ChangeListener(LDAPDirectory remoteDirectory, Name baseDN, String objectFilter, ContextMapper mapper, EventPublisher eventPublisher, boolean lookupUpdates) {
        this.remoteDirectory = remoteDirectory;
        this.baseDN = baseDN;
        this.objectFilter = objectFilter;
        this.mapper = mapper;
        this.eventPublisher = eventPublisher;
        this.lookupUpdates = lookupUpdates;
    }

    public long getDirectoryID() {
        return this.remoteDirectory.getDirectoryId();
    }

    public Name getBaseDN() {
        return this.baseDN;
    }

    public String getObjectFilter() {
        return this.objectFilter;
    }

    protected DirContextAdapter buildContextAdapter(SearchResult result) {
        return new DirContextAdapter(result.getAttributes(), (Name)new DistinguishedName(result.getName()));
    }

    protected abstract void publishEntityCreatedEvent(Object var1);

    protected abstract void publishEntityUpdatedEvent(Object var1);

    protected abstract void publishEntityDeletedEvent(Object var1);

    protected abstract Object lookupEntity(String var1);

    @Override
    public void objectAdded(NamingEvent event) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("objectAdded event " + event.getNewBinding().getName()));
        }
        if (event.getNewBinding() != null && event.getNewBinding() instanceof SearchResult) {
            DirContextAdapter ctx = this.buildContextAdapter((SearchResult)event.getNewBinding());
            Object entity = this.mapper.mapFromContext((Object)ctx);
            this.publishEntityCreatedEvent(entity);
        } else {
            this.logger.error((Object)("Received objectAdded event but new binding not present from directory with ID: " + this.getDirectoryID()));
        }
    }

    @Override
    public void objectChanged(NamingEvent event) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("objectChanged event " + event.getNewBinding().getName()));
        }
        if (event.getNewBinding() != null && event.getNewBinding() instanceof SearchResult) {
            Object entity = null;
            if (this.lookupUpdates) {
                entity = this.lookupEntity(event.getNewBinding().getName());
            } else {
                DirContextAdapter ctx = this.buildContextAdapter((SearchResult)event.getNewBinding());
                entity = this.mapper.mapFromContext((Object)ctx);
            }
            if (entity != null) {
                this.publishEntityUpdatedEvent(entity);
            }
        } else {
            this.logger.error((Object)("Received objectChanged event but new binding not present from directory with ID: " + this.getDirectoryID()));
        }
    }

    @Override
    public void objectRemoved(NamingEvent event) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("objectRemoved event " + event.getOldBinding().getName()));
        }
        if (event.getOldBinding() != null && event.getOldBinding() instanceof SearchResult) {
            DirContextAdapter ctx = this.buildContextAdapter((SearchResult)event.getOldBinding());
            Object entity = this.mapper.mapFromContext((Object)ctx);
            this.publishEntityDeletedEvent(entity);
        } else {
            this.logger.error((Object)("Received objectRemoved event but old binding not present from directory with ID: " + this.getDirectoryID()));
        }
    }

    @Override
    public void objectRenamed(NamingEvent event) {
        this.logger.error((Object)("Recieved objectRenamed event " + event.getNewBinding().getName() + ". Crowd's cache does not support object renaming."));
        this.eventPublisher.publish((Object)new RemoteDirectoryMonitorErrorEvent(this, this.getDirectoryID(), new UnsupportedOperationException("Renaming objects is not supported")));
    }

    @Override
    public void namingExceptionThrown(NamingExceptionEvent event) {
        this.logger.error((Object)("namingExceptionThrown event " + event.getException().getMessage()));
        this.eventPublisher.publish((Object)new RemoteDirectoryMonitorErrorEvent(this, this.getDirectoryID(), event.getException()));
    }
}

