/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.directory;

import com.atlassian.crowd.directory.SpringLDAPConnector;
import com.atlassian.crowd.directory.ldap.mapper.attribute.AttributeMapper;
import com.atlassian.crowd.directory.ldap.mapper.attribute.RFC2307GidNumberMapper;
import com.atlassian.crowd.directory.ldap.mapper.attribute.group.RFC2307MemberUidMapper;
import com.atlassian.crowd.embedded.api.Attributes;
import com.atlassian.crowd.exception.GroupNotFoundException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.model.group.GroupType;
import com.atlassian.crowd.model.group.LDAPGroupWithAttributes;
import com.atlassian.crowd.model.user.LDAPUserWithAttributes;
import com.atlassian.crowd.search.Entity;
import com.atlassian.crowd.search.ldap.LDAPQueryTranslater;
import com.atlassian.crowd.search.query.membership.MembershipQuery;
import com.atlassian.crowd.search.util.SearchResultsUtil;
import com.atlassian.crowd.util.InstanceFactory;
import com.atlassian.event.api.EventPublisher;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.naming.Name;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.apache.log4j.Logger;
import org.springframework.ldap.core.ContextMapper;
import org.springframework.ldap.filter.AndFilter;
import org.springframework.ldap.filter.EqualsFilter;
import org.springframework.ldap.filter.Filter;
import org.springframework.ldap.filter.HardcodedFilter;
import org.springframework.ldap.filter.OrFilter;

public abstract class RFC2307Directory
extends SpringLDAPConnector {
    private static final Logger logger = Logger.getLogger(RFC2307Directory.class);

    public RFC2307Directory(LDAPQueryTranslater ldapQueryTranslater, EventPublisher eventPublisher, InstanceFactory instanceFactory) {
        super(ldapQueryTranslater, eventPublisher, instanceFactory);
    }

    @Override
    protected List<AttributeMapper> getCustomGroupAttributeMappers() {
        List<AttributeMapper> mappers = super.getCustomGroupAttributeMappers();
        mappers.add(new RFC2307MemberUidMapper(this.ldapPropertiesMapper.getGroupMemberAttribute()));
        mappers.add(new RFC2307GidNumberMapper());
        return mappers;
    }

    @Override
    protected List<AttributeMapper> getCustomUserAttributeMappers() {
        List<AttributeMapper> mappers = super.getCustomUserAttributeMappers();
        mappers.add(new RFC2307GidNumberMapper());
        return mappers;
    }

    private Set<String> getMemberNames(LDAPGroupWithAttributes group) {
        return group.getValues("memberUIDs");
    }

    private String getGid(Attributes entity) {
        return entity.getValue("gidNumber");
    }

    public boolean isUserDirectGroupMember(String username, String groupName) throws OperationFailedException {
        Validate.notEmpty((String)username, (String)"username argument cannot be null or empty");
        Validate.notEmpty((String)groupName, (String)"groupName argument cannot be null or empty");
        boolean isMember = false;
        try {
            String groupGid;
            LDAPUserWithAttributes user;
            String userGid;
            LDAPGroupWithAttributes group = this.findGroupByName(groupName);
            Set<String> memberNames = this.getMemberNames(group);
            if (memberNames != null) {
                for (String member : memberNames) {
                    if (!member.equalsIgnoreCase(username)) continue;
                    isMember = true;
                    break;
                }
            }
            if (!isMember && StringUtils.equals((String)(userGid = this.getGid(user = this.findUserByName(username))), (String)(groupGid = this.getGid(group)))) {
                isMember = true;
            }
        }
        catch (UserNotFoundException e) {
        }
        catch (GroupNotFoundException e) {
            // empty catch block
        }
        return isMember;
    }

    public boolean isGroupDirectGroupMember(String childGroup, String parentGroup) {
        return false;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected <T> List<T> searchGroupRelationshipsWithGroupTypeSpecified(MembershipQuery<T> query) throws OperationFailedException {
        void var2_6;
        Validate.notNull(query, (String)"query argument cannot be null");
        if (query.isFindChildren()) {
            if (query.getEntityToMatch().getEntityType() != Entity.GROUP) throw new IllegalArgumentException("You can only find the GROUP or USER members of a GROUP");
            if (query.getEntityToReturn().getEntityType() == Entity.USER) {
                List<LDAPUserWithAttributes> list = this.findUserMembersOfGroup(query.getEntityNameToMatch(), query.getEntityToMatch().getGroupType(), query.getStartIndex(), query.getMaxResults());
            } else {
                if (query.getEntityToReturn().getEntityType() != Entity.GROUP) throw new IllegalArgumentException("You can only find the GROUP or USER members of a GROUP");
                List list = Collections.emptyList();
            }
        } else {
            if (query.getEntityToReturn().getEntityType() != Entity.GROUP) throw new IllegalArgumentException("You can only find the GROUP memberships of USER or GROUP");
            if (query.getEntityToMatch().getEntityType() == Entity.USER) {
                List<LDAPGroupWithAttributes> list = this.findGroupMembershipsOfUser(query.getEntityNameToMatch(), query.getEntityToReturn().getGroupType(), query.getStartIndex(), query.getMaxResults());
            } else {
                if (query.getEntityToMatch().getEntityType() != Entity.GROUP) throw new IllegalArgumentException("You can only find the GROUP memberships of USER or GROUP");
                List list = Collections.emptyList();
            }
        }
        if (query.getReturnType() != String.class) return var2_6;
        return SearchResultsUtil.convertEntitiesToNames((List)var2_6);
    }

    private List<LDAPGroupWithAttributes> findGroupMembershipsOfUser(String username, GroupType groupType, int startIndex, int maxResults) throws OperationFailedException {
        try {
            String containerFilter;
            String memberAttribute;
            Name baseDN;
            ContextMapper contextMapper = this.getGroupContextMapper(groupType);
            if (groupType == GroupType.GROUP) {
                baseDN = this.searchDN.getGroup();
                memberAttribute = this.ldapPropertiesMapper.getGroupMemberAttribute();
                containerFilter = this.ldapPropertiesMapper.getGroupFilter();
            } else if (groupType == GroupType.LEGACY_ROLE) {
                baseDN = this.searchDN.getRole();
                memberAttribute = this.ldapPropertiesMapper.getRoleMemberAttribute();
                containerFilter = this.ldapPropertiesMapper.getRoleFilter();
            } else {
                throw new IllegalArgumentException("Cannot find membership of user that are of GroupType: " + groupType);
            }
            LDAPUserWithAttributes user = this.findUserByName(username);
            String gidNumber = this.getGid(user);
            OrFilter membershipFilter = new OrFilter();
            membershipFilter.or((Filter)new EqualsFilter(memberAttribute, user.getName()));
            if (gidNumber != null) {
                membershipFilter.or((Filter)new EqualsFilter("gidNumber", gidNumber));
            }
            AndFilter rootFilter = new AndFilter();
            rootFilter.and((Filter)new HardcodedFilter(containerFilter));
            rootFilter.and((Filter)membershipFilter);
            return this.searchEntities(baseDN, rootFilter.encode(), contextMapper, startIndex, maxResults);
        }
        catch (UserNotFoundException e) {
            return Collections.emptyList();
        }
    }

    private List<LDAPUserWithAttributes> findUserMembersOfGroup(String groupName, GroupType groupType, int startIndex, int maxResults) throws OperationFailedException {
        try {
            Set<String> memberNames;
            LDAPGroupWithAttributes group = this.findGroupByNameAndType(groupName, groupType);
            HashSet<LDAPUserWithAttributes> members = new HashSet<LDAPUserWithAttributes>();
            String gidNumber = this.getGid(group);
            if (gidNumber != null) {
                try {
                    AndFilter filter = new AndFilter();
                    filter.and((Filter)new HardcodedFilter(this.ldapPropertiesMapper.getUserFilter()));
                    filter.and((Filter)new EqualsFilter("gidNumber", gidNumber));
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Executing search at DN: <" + this.searchDN.getUser() + "> with filter: <" + filter.encode() + ">"));
                    }
                    members.addAll(this.searchEntities(this.searchDN.getUser(), filter.encode(), this.getUserContextMapper(), startIndex, maxResults));
                }
                catch (OperationFailedException e) {
                    logger.debug((Object)("Unable to get gid members for group: " + group.getDn()), (Throwable)e);
                }
            }
            if ((memberNames = this.getMemberNames(group)) != null) {
                for (String memberName : memberNames) {
                    try {
                        members.add(this.findUserByName(memberName));
                    }
                    catch (UserNotFoundException e) {}
                }
            }
            return SearchResultsUtil.constrainResults(new ArrayList(members), (int)startIndex, (int)maxResults);
        }
        catch (GroupNotFoundException e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Group with name <" + groupName + "> does not exist and therefore has no members"));
            }
            return Collections.emptyList();
        }
    }

    @Override
    public boolean supportsNestedGroups() {
        return false;
    }
}

