/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.directory;

import com.atlassian.crowd.directory.RFC4519Directory;
import com.atlassian.crowd.directory.ldap.control.DeletedResultsControl;
import com.atlassian.crowd.directory.ldap.mapper.TombstoneContextMapper;
import com.atlassian.crowd.directory.ldap.mapper.attribute.AttributeMapper;
import com.atlassian.crowd.directory.ldap.mapper.attribute.ObjectGUIDMapper;
import com.atlassian.crowd.directory.ldap.mapper.attribute.USNChangedMapper;
import com.atlassian.crowd.directory.ldap.mapper.attribute.group.RFC4519MemberDnRangeOffsetMapper;
import com.atlassian.crowd.directory.ldap.mapper.attribute.group.RFC4519MemberDnRangedMapper;
import com.atlassian.crowd.directory.ldap.name.ActiveDirectoryEncoder;
import com.atlassian.crowd.directory.ldap.name.Encoder;
import com.atlassian.crowd.directory.ldap.util.DNStandardiser;
import com.atlassian.crowd.directory.ldap.util.IncrementalAttributeMapper;
import com.atlassian.crowd.directory.ldap.util.ListAttributeValueProcessor;
import com.atlassian.crowd.directory.ldap.util.RangeOption;
import com.atlassian.crowd.exception.InvalidCredentialException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.model.Tombstone;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.group.GroupTemplateWithAttributes;
import com.atlassian.crowd.model.group.GroupType;
import com.atlassian.crowd.model.group.GroupWithAttributes;
import com.atlassian.crowd.model.group.LDAPGroupWithAttributes;
import com.atlassian.crowd.model.user.LDAPUserWithAttributes;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.search.ldap.LDAPQueryTranslater;
import com.atlassian.crowd.util.InstanceFactory;
import com.atlassian.event.api.EventPublisher;
import com.google.common.collect.Lists;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.naming.CompositeName;
import javax.naming.Name;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.SearchControls;
import org.apache.log4j.Logger;
import org.springframework.ldap.NamingException;
import org.springframework.ldap.core.AttributesMapper;
import org.springframework.ldap.core.ContextMapper;
import org.springframework.ldap.core.DirContextAdapter;
import org.springframework.ldap.core.DirContextProcessor;
import org.springframework.ldap.filter.AndFilter;
import org.springframework.ldap.filter.EqualsFilter;
import org.springframework.ldap.filter.Filter;
import org.springframework.ldap.filter.GreaterThanOrEqualsFilter;
import org.springframework.ldap.filter.HardcodedFilter;

public class MicrosoftActiveDirectory
extends RFC4519Directory {
    private static final Logger logger = Logger.getLogger(MicrosoftActiveDirectory.class);
    private static final String PRINCIPAL_NO_SSL_CONNECTION = "Secure SSL connections for this directory are not configured; unable to perform this operation.";
    private static final int UF_ACCOUNTDISABLE = 2;
    private static final int UF_PASSWD_NOTREQD = 32;
    private static final int UF_PASSWD_CANT_CHANGE = 64;
    private static final int UF_NORMAL_ACCOUNT = 512;
    private static final int UF_DONT_EXPIRE_PASSWD = 65536;
    private static final int UF_PASSWORD_EXPIRED = 0x800000;
    private static final String AD_USER_ACCOUNT_CONTROL = "userAccountControl";
    private static final String AD_SAM_ACCOUNT_NAME = "samAccountName";
    private static final String AD_PASSWORD_ENCODED = "UTF-16LE";
    private static final String AD_MEMBEROF = "memberOf";
    private static final String AD_HIGHEST_COMMITTED_USN = "highestCommittedUSN";
    private static final String AD_IS_DELETED = "isDeleted";
    private static final String AD_OBJECT_CLASS = "objectClass";
    private static final String DELETED_OBJECTS_DN_ADDITION = "CN=Deleted Objects";
    private static final String ROOT_DOMAIN_NAMING_CONTEXT = "rootDomainNamingContext";
    private static final String GROUP_TYPE_NAME = "groupType";
    private static final String GROUP_TYPE_VALUE = "2";

    public MicrosoftActiveDirectory(LDAPQueryTranslater ldapQueryTranslater, EventPublisher eventPublisher, InstanceFactory instanceFactory) {
        super(ldapQueryTranslater, eventPublisher, instanceFactory);
    }

    public static String getStaticDirectoryType() {
        return "Microsoft Active Directory";
    }

    public String getDescriptiveName() {
        return MicrosoftActiveDirectory.getStaticDirectoryType();
    }

    @Override
    protected Encoder getEncoder() {
        return new ActiveDirectoryEncoder();
    }

    @Override
    protected String getInitialGroupMemberDN() {
        return null;
    }

    protected byte[] encodePassword(String unencodedPassword) throws InvalidCredentialException {
        try {
            String newQuotedPassword = "\"" + unencodedPassword + "\"";
            return newQuotedPassword.getBytes(AD_PASSWORD_ENCODED);
        }
        catch (UnsupportedEncodingException e) {
            throw new InvalidCredentialException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    protected void getNewUserDirectorySpecificAttributes(User user, Attributes attributes) {
        attributes.put(AD_SAM_ACCOUNT_NAME, user.getName());
        String accountStatus = null;
        accountStatus = user.isActive() ? Integer.toString(0x800220) : Integer.toString(0x800222);
        attributes.put(new BasicAttribute(AD_USER_ACCOUNT_CONTROL, accountStatus));
    }

    @Override
    protected void getNewGroupDirectorySpecificAttributes(Group group, Attributes attributes) {
        attributes.put(GROUP_TYPE_NAME, GROUP_TYPE_VALUE);
    }

    @Override
    protected List<AttributeMapper> getCustomUserAttributeMappers() {
        List<AttributeMapper> mappers = super.getCustomUserAttributeMappers();
        mappers.add(new ObjectGUIDMapper());
        mappers.add(new USNChangedMapper());
        return mappers;
    }

    @Override
    protected List<AttributeMapper> getCustomGroupAttributeMappers() {
        List<AttributeMapper> mappers = super.getCustomGroupAttributeMappers();
        mappers.add(new ObjectGUIDMapper());
        mappers.add(new USNChangedMapper());
        return mappers;
    }

    @Override
    protected List<AttributeMapper> getMemberDnMappers() {
        return Arrays.asList(new RFC4519MemberDnRangedMapper(this.ldapPropertiesMapper.getGroupMemberAttribute(), this.ldapPropertiesMapper.isRelaxedDnStandardisation()), new RFC4519MemberDnRangeOffsetMapper(this.ldapPropertiesMapper.getGroupMemberAttribute()));
    }

    @Override
    protected List<LDAPGroupWithAttributes> postprocessGroups(List<LDAPGroupWithAttributes> groups) {
        ArrayList result = Lists.newArrayList();
        for (LDAPGroupWithAttributes group : groups) {
            if (group.getValue("memberRangeStart") != null) {
                ListAttributeValueProcessor valueAggregator = new ListAttributeValueProcessor();
                String rangeStart = group.getValue("memberRangeStart");
                RangeOption range = new RangeOption(Integer.valueOf(rangeStart));
                IncrementalAttributeMapper incrementalAttributeMapper = new IncrementalAttributeMapper(this.ldapPropertiesMapper.getGroupMemberAttribute(), valueAggregator, range);
                while (incrementalAttributeMapper.hasMore()) {
                    this.ldapTemplate.lookup(group.getDn(), incrementalAttributeMapper.getAttributesArray(), (AttributesMapper)incrementalAttributeMapper);
                }
                Set<String> initialMembers = group.getValues("memberDNs");
                HashSet<String> standardDNs = new HashSet<String>(initialMembers.size() + valueAggregator.getValues().size());
                standardDNs.addAll(initialMembers);
                for (String memberDN : valueAggregator.getValues()) {
                    String dn = DNStandardiser.standardise(memberDN, !this.ldapPropertiesMapper.isRelaxedDnStandardisation());
                    standardDNs.add(dn);
                }
                GroupTemplateWithAttributes groupTemplate = new GroupTemplateWithAttributes((GroupWithAttributes)group);
                groupTemplate.setAttribute("memberDNs", standardDNs);
                groupTemplate.removeAttribute("memberRangeStart");
                result.add(new LDAPGroupWithAttributes(group.getDn(), groupTemplate));
                continue;
            }
            result.add(group);
        }
        return result;
    }

    @Override
    protected Map<String, String> getBaseEnvironmentProperties() {
        Map<String, String> env = super.getBaseEnvironmentProperties();
        env.put("java.naming.ldap.attributes.binary", "objectGUID");
        return env;
    }

    public long fetchHighestCommittedUSN() throws OperationFailedException {
        try {
            Attribute highestCommittedUSN = ((DirContextAdapter)this.ldapTemplate.lookup("")).getAttributes().get(AD_HIGHEST_COMMITTED_USN);
            long usn = Long.parseLong((String)highestCommittedUSN.get(0));
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Fetched highest committed uSN of " + usn));
            }
            return usn;
        }
        catch (javax.naming.NamingException e) {
            logger.error((Object)"Error retrieving highestCommittedUSN from AD root", (Throwable)e);
            throw new OperationFailedException("Error retrieving highestCommittedUSN from AD root", (Throwable)e);
        }
        catch (NamingException e) {
            logger.error((Object)"Error looking up attributes for highestCommittedUSN", (Throwable)e);
            throw new OperationFailedException("Error looking up attributes for highestCommittedUSN", (Throwable)e);
        }
    }

    public List<LDAPUserWithAttributes> findAddedOrUpdatedUsersSince(long usnChange) throws OperationFailedException {
        return this.findAddedOrUpdatedObjectsSince(usnChange, this.searchDN.getUser(), this.ldapPropertiesMapper.getUserFilter(), this.getUserContextMapper());
    }

    public List<LDAPGroupWithAttributes> findAddedOrUpdatedGroupsSince(long usnChanged) throws OperationFailedException {
        return this.findAddedOrUpdatedObjectsSince(usnChanged, this.searchDN.getGroup(), this.ldapPropertiesMapper.getGroupFilter(), this.getGroupContextMapper(GroupType.GROUP));
    }

    public List<Tombstone> findUserTombstonesSince(long usnChange) throws OperationFailedException {
        return this.findTombstonesSince(usnChange, this.searchDN.getUser(), this.ldapPropertiesMapper.getUserObjectClass());
    }

    public List<Tombstone> findGroupTombstonesSince(long usnChange) throws OperationFailedException {
        return this.findTombstonesSince(usnChange, this.searchDN.getGroup(), this.ldapPropertiesMapper.getGroupObjectClass());
    }

    protected List findAddedOrUpdatedObjectsSince(long usnChange, Name objectBaseDN, String objectFilter, ContextMapper contextMapper) throws OperationFailedException {
        AndFilter filter = new AndFilter();
        filter.and((Filter)new HardcodedFilter(objectFilter));
        filter.and((Filter)new GreaterThanOrEqualsFilter("uSNChanged", Long.toString(usnChange + 1L)));
        logger.debug((Object)("Performing polling search: baseDN = " + objectBaseDN + " - filter = " + filter.encode()));
        return this.searchEntities(objectBaseDN, filter.encode(), contextMapper, 0, -1);
    }

    private Name getDeletedObjectsDN() {
        try {
            DirContextAdapter root = (DirContextAdapter)this.ldapTemplate.lookup("");
            String rootDN = root.getStringAttribute(ROOT_DOMAIN_NAMING_CONTEXT);
            String dn = new StringBuffer(DELETED_OBJECTS_DN_ADDITION).append(",").append(rootDN).toString();
            return new CompositeName(dn);
        }
        catch (javax.naming.NamingException e) {
            return this.searchDN.getNamingContext();
        }
    }

    protected List<Tombstone> findTombstonesSince(long usnChange, Name objectBaseDN, String objectClass) throws OperationFailedException {
        SearchControls searchControls = this.getSubTreeSearchControl();
        searchControls.setReturningAttributes(new String[]{"objectGUID", "uSNChanged"});
        AndFilter filter = new AndFilter();
        filter.and((Filter)new EqualsFilter(AD_IS_DELETED, "TRUE"));
        filter.and((Filter)new EqualsFilter(AD_OBJECT_CLASS, objectClass));
        filter.and((Filter)new GreaterThanOrEqualsFilter("uSNChanged", Long.toString(usnChange + 1L)));
        Name deletedObjectsDN = this.getDeletedObjectsDN();
        logger.debug((Object)("Performing tombstones search: baseDN = " + deletedObjectsDN + " - filter = " + filter.encode()));
        TombstoneContextMapper contextMapper = new TombstoneContextMapper();
        return this.searchEntitiesWithRequestControls(deletedObjectsDN, filter.encode(), contextMapper, searchControls, (DirContextProcessor)new DeletedResultsControl(), 0, -1);
    }
}

