/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.directory.ldap.cache;

import com.atlassian.crowd.directory.RemoteDirectory;
import com.atlassian.crowd.directory.ldap.cache.CacheRefresher;
import com.atlassian.crowd.directory.ldap.cache.DirectoryCache;
import com.atlassian.crowd.event.directory.RemoteDirectorySynchronisedEvent;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.group.GroupType;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.event.api.EventPublisher;
import java.util.List;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCacheRefresher
implements CacheRefresher {
    private static final Logger log = Logger.getLogger(AbstractCacheRefresher.class);
    static final int MEMBERSHIP_LOG_FREQUENCY = 5;
    protected final RemoteDirectory remoteDirectory;
    protected final EventPublisher eventPublisher;

    public AbstractCacheRefresher(RemoteDirectory remoteDirectory, EventPublisher eventPublisher) {
        this.remoteDirectory = remoteDirectory;
        this.eventPublisher = eventPublisher;
    }

    @Override
    public void synchroniseAll(DirectoryCache directoryCache) throws OperationFailedException {
        this.synchroniseAllUsers(directoryCache);
        List<? extends Group> allGroups = this.synchroniseAllGroups(GroupType.GROUP, directoryCache);
        this.synchroniseMemberships(GroupType.GROUP, allGroups, directoryCache);
        if (!this.remoteDirectory.isRolesDisabled()) {
            List<? extends Group> allRoles = this.synchroniseAllGroups(GroupType.LEGACY_ROLE, directoryCache);
            this.synchroniseMemberships(GroupType.LEGACY_ROLE, allRoles, directoryCache);
        }
        this.eventPublisher.publish((Object)new RemoteDirectorySynchronisedEvent((Object)this, this.remoteDirectory));
    }

    protected abstract void synchroniseAllUsers(DirectoryCache var1) throws OperationFailedException;

    protected abstract List<? extends Group> synchroniseAllGroups(GroupType var1, DirectoryCache var2) throws OperationFailedException;

    protected void synchroniseMemberships(GroupType groupType, List<? extends Group> remoteGroups, DirectoryCache directoryCache) throws OperationFailedException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Updating memberships for " + remoteGroups.size() + " " + groupType.name() + "s from " + this.directoryDescription()));
        }
        for (Group group : remoteGroups) {
            this.synchroniseMembershipsForGroup(groupType, group, directoryCache);
        }
        int total = remoteGroups.size();
        int n = total / 5;
        for (int i = 0; i < total; ++i) {
            this.synchroniseMembershipsForGroup(groupType, remoteGroups.get(i), directoryCache);
            if (n != 0 && i % n != 0) continue;
            log.info((Object)("Migrated memberships for [" + i + "] of [" + total + "] groups"));
        }
    }

    private List<String> findAllUserMembersOfGroup(String name, GroupType type) throws OperationFailedException {
        long start = System.currentTimeMillis();
        List names = this.remoteDirectory.searchGroupRelationships(QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.group((GroupType)type)).withName(name).returningAtMost(-1));
        log.info((Object)("found [ " + names.size() + " ] remote user-group memberships in [ " + (System.currentTimeMillis() - start) + "ms ]"));
        return names;
    }

    private List<String> findAllGroupMembersOfGroup(String name, GroupType type) throws OperationFailedException {
        long start = System.currentTimeMillis();
        List names = this.remoteDirectory.searchGroupRelationships(QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group((GroupType)type)).childrenOf(EntityDescriptor.group((GroupType)type)).withName(name).returningAtMost(-1));
        log.info((Object)("found [ " + names.size() + " ] remote group-group memberships in [ " + (System.currentTimeMillis() - start) + "ms ]"));
        return names;
    }

    protected void synchroniseMembershipsForGroup(GroupType groupType, Group ldapGroup, DirectoryCache directoryCache) throws OperationFailedException {
        List<String> ldapUsers = this.findAllUserMembersOfGroup(ldapGroup.getName(), groupType);
        directoryCache.syncUserMembershipsForGroup(ldapGroup, ldapUsers);
        List<String> ldapSubGroups = this.findAllGroupMembersOfGroup(ldapGroup.getName(), groupType);
        directoryCache.syncGroupMembershipsForGroup(ldapGroup, ldapSubGroups);
    }

    protected String directoryDescription() {
        return this.remoteDirectory.getDescriptiveName() + " Directory " + this.remoteDirectory.getDirectoryId();
    }
}

