/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.directory.ldap.monitor.listener;

import com.atlassian.crowd.directory.LDAPDirectory;
import com.atlassian.crowd.directory.ldap.monitor.listener.ChangeListener;
import com.atlassian.crowd.event.remote.group.RemoteGroupCreatedEvent;
import com.atlassian.crowd.event.remote.group.RemoteGroupDeletedEvent;
import com.atlassian.crowd.event.remote.group.RemoteGroupUpdatedEvent;
import com.atlassian.crowd.exception.GroupNotFoundException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.group.LDAPGroupWithAttributes;
import com.atlassian.event.api.EventPublisher;
import javax.naming.Name;
import org.springframework.ldap.core.ContextMapper;

public class GroupChangeListener
extends ChangeListener {
    public GroupChangeListener(LDAPDirectory remoteDirectory, Name baseDN, String objectFilter, ContextMapper mapper, EventPublisher eventPublisher, boolean lookupUpdates) {
        super(remoteDirectory, baseDN, objectFilter, mapper, eventPublisher, lookupUpdates);
    }

    protected void publishEntityCreatedEvent(Object entity) {
        this.eventPublisher.publish((Object)new RemoteGroupCreatedEvent((Object)this, this.getDirectoryID(), (Group)entity));
    }

    protected void publishEntityUpdatedEvent(Object entity) {
        this.eventPublisher.publish((Object)new RemoteGroupUpdatedEvent((Object)this, this.getDirectoryID(), (Group)entity));
    }

    protected void publishEntityDeletedEvent(Object entity) {
        this.eventPublisher.publish((Object)new RemoteGroupDeletedEvent(this, this.getDirectoryID(), ((Group)entity).getName()));
    }

    protected Object lookupEntity(String dn) {
        try {
            return this.remoteDirectory.findEntityByDN(dn, LDAPGroupWithAttributes.class);
        }
        catch (GroupNotFoundException e) {
            return null;
        }
        catch (OperationFailedException e) {
            return null;
        }
        catch (UserNotFoundException e) {
            throw new AssertionError((Object)"Should not throw a UserNotFoundException");
        }
    }
}

