/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.directory.ldap.mapper;

import com.atlassian.crowd.directory.ldap.mapper.attribute.ObjectGUIDMapper;
import com.atlassian.crowd.directory.ldap.mapper.attribute.USNChangedMapper;
import com.atlassian.crowd.model.Tombstone;
import org.springframework.ldap.core.ContextMapper;
import org.springframework.ldap.core.DirContextAdapter;

public class TombstoneContextMapper
implements ContextMapper {
    private final ObjectGUIDMapper objectGUIDMapper = new ObjectGUIDMapper();
    private final USNChangedMapper usnChangedMapper = new USNChangedMapper();

    public Object mapFromContext(Object ctx) {
        try {
            DirContextAdapter context = (DirContextAdapter)ctx;
            String guid = this.objectGUIDMapper.getValues(context).iterator().next();
            String usnChanged = this.usnChangedMapper.getValues(context).iterator().next();
            return new Tombstone(guid, usnChanged);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not retrieve objectGUID/uSNChanged from object: " + ((DirContextAdapter)ctx).getDn());
        }
    }
}

