/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.directory;

import com.atlassian.crowd.directory.RFC4519Directory;
import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.model.group.ImmutableMembership;
import com.atlassian.crowd.model.group.Membership;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.naming.ldap.LdapName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RFC4519DirectoryMembershipsIterable
implements Iterable<Membership> {
    private static final Logger logger = LoggerFactory.getLogger(RFC4519DirectoryMembershipsIterable.class);
    private final RFC4519Directory connector;
    private final Map<LdapName, String> users;
    private final Map<LdapName, String> groups;
    private final Set<String> groupsToInclude;
    private final Predicate<String> groupIsIncluded = new Predicate<String>(){

        public boolean apply(String name) {
            return RFC4519DirectoryMembershipsIterable.this.groupsToInclude.contains(IdentifierUtils.toLowerCase((String)name));
        }
    };
    private Function<? super Map.Entry<LdapName, String>, ? extends Membership> lookUpMembers = new Function<Map.Entry<LdapName, String>, Membership>(){

        public Membership apply(Map.Entry<LdapName, String> input) {
            Iterable<LdapName> directMembers;
            try {
                directMembers = RFC4519DirectoryMembershipsIterable.this.connector.findDirectMembersOfGroup(input.getKey());
            }
            catch (OperationFailedException e) {
                throw new Membership.MembershipIterationException((Throwable)e);
            }
            String groupName = input.getValue();
            ImmutableSet.Builder userNames = ImmutableSet.builder();
            ImmutableSet.Builder childGroupNames = ImmutableSet.builder();
            for (LdapName member : directMembers) {
                if (RFC4519DirectoryMembershipsIterable.this.users.containsKey(member)) {
                    userNames.add(RFC4519DirectoryMembershipsIterable.this.users.get(member));
                }
                if (RFC4519DirectoryMembershipsIterable.this.groups.containsKey(member)) {
                    childGroupNames.add(RFC4519DirectoryMembershipsIterable.this.groups.get(member));
                }
                if (RFC4519DirectoryMembershipsIterable.this.users.containsKey(member) || RFC4519DirectoryMembershipsIterable.this.groups.containsKey(member)) continue;
                logger.debug("Unexpected DN in group '{}': {}", (Object)groupName, (Object)member);
            }
            return new ImmutableMembership(groupName, (Iterable)userNames.build(), (Iterable)childGroupNames.build());
        }
    };

    public RFC4519DirectoryMembershipsIterable(RFC4519Directory connector, Map<LdapName, String> users, Map<LdapName, String> groups, Set<String> groupsToInclude) {
        this.connector = connector;
        this.users = users;
        this.groups = groups;
        this.groupsToInclude = groupsToInclude;
    }

    public RFC4519DirectoryMembershipsIterable(RFC4519Directory springLDAPConnector, Map<LdapName, String> users, Map<LdapName, String> groups) {
        this(springLDAPConnector, users, groups, (Set<String>)ImmutableSet.copyOf((Iterable)Iterables.transform(groups.values(), (Function)IdentifierUtils.TO_LOWER_CASE)));
    }

    @Override
    public Iterator<Membership> iterator() {
        Map groupsToRetrieve = Maps.filterValues(this.groups, this.groupIsIncluded);
        return Iterators.transform(groupsToRetrieve.entrySet().iterator(), this.lookUpMembers);
    }
}

