/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.springsecurity.user;

import com.atlassian.crowd.exception.InvalidAuthenticationException;
import com.atlassian.crowd.exception.InvalidAuthorizationTokenException;
import com.atlassian.crowd.exception.InvalidTokenException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.integration.soap.SOAPPrincipal;
import com.atlassian.crowd.integration.springsecurity.CrowdSSOTokenInvalidException;
import com.atlassian.crowd.integration.springsecurity.user.CrowdDataAccessException;
import com.atlassian.crowd.integration.springsecurity.user.CrowdUserDetails;
import com.atlassian.crowd.integration.springsecurity.user.CrowdUserDetailsService;
import com.atlassian.crowd.service.GroupMembershipManager;
import com.atlassian.crowd.service.UserManager;
import com.atlassian.crowd.user.UserAuthoritiesProvider;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.dao.DataAccessException;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.UsernameNotFoundException;

public class CrowdUserDetailsServiceImpl
implements CrowdUserDetailsService {
    private UserManager userManager;
    private GroupMembershipManager groupMembershipManager;
    private String authorityPrefix = "";
    private Iterable<Map.Entry<String, String>> groupToAuthorityMappings;
    private String adminAuthority = "ROLE_ADMIN";
    private UserAuthoritiesProvider userAuthoritiesProvider;

    @Override
    public CrowdUserDetails loadUserByUsername(String username) throws UsernameNotFoundException, DataAccessException {
        try {
            SOAPPrincipal principal = this.userManager.getUser(username);
            return new CrowdUserDetails(principal, this.getAuthorities(principal.getName()));
        }
        catch (InvalidAuthorizationTokenException e) {
            throw new CrowdDataAccessException((Exception)((Object)e));
        }
        catch (RemoteException e) {
            throw new CrowdDataAccessException(e);
        }
        catch (UserNotFoundException e) {
            throw new UsernameNotFoundException("Could not find principal in Crowd with username: " + username, (Throwable)e);
        }
        catch (InvalidAuthenticationException e) {
            throw new CrowdDataAccessException((Exception)((Object)e));
        }
    }

    @Override
    public CrowdUserDetails loadUserByToken(String token) throws CrowdSSOTokenInvalidException, DataAccessException {
        try {
            SOAPPrincipal principal = this.userManager.getUserFromToken(token);
            return new CrowdUserDetails(principal, this.getAuthorities(principal.getName()));
        }
        catch (InvalidAuthorizationTokenException e) {
            throw new CrowdDataAccessException((Exception)((Object)e));
        }
        catch (RemoteException e) {
            throw new CrowdDataAccessException(e);
        }
        catch (UsernameNotFoundException e) {
            throw new CrowdDataAccessException((Exception)((Object)e));
        }
        catch (InvalidTokenException e) {
            throw new CrowdSSOTokenInvalidException(e.getMessage(), e);
        }
        catch (InvalidAuthenticationException e) {
            throw new CrowdDataAccessException((Exception)((Object)e));
        }
        catch (UserNotFoundException e) {
            throw new CrowdDataAccessException((Exception)((Object)e));
        }
    }

    Collection<GrantedAuthority> getAuthorities(String username) throws InvalidAuthorizationTokenException, RemoteException, UserNotFoundException, InvalidAuthenticationException {
        if (this.userAuthoritiesProvider != null) {
            ArrayList<GrantedAuthority> authorities = new ArrayList<GrantedAuthority>();
            for (String authority : this.userAuthoritiesProvider.getAuthorityNames(username)) {
                authorities.add((GrantedAuthority)new SimpleGrantedAuthority(authority));
            }
            return authorities;
        }
        if (this.groupToAuthorityMappings == null) {
            List userGroups = this.groupMembershipManager.getMemberships(username);
            return this.generateAuthoritiesFromGroupNames(userGroups);
        }
        return this.generateAuthorityFromMap(username);
    }

    private Set<GrantedAuthority> generateAuthorityFromMap(String username) throws RemoteException, InvalidAuthenticationException, InvalidAuthorizationTokenException {
        HashSet<GrantedAuthority> authorities = new HashSet<GrantedAuthority>();
        for (Map.Entry<String, String> groupToAuthorityMapEntry : this.groupToAuthorityMappings) {
            if (!this.groupMembershipManager.isMember(username, groupToAuthorityMapEntry.getKey())) continue;
            authorities.add((GrantedAuthority)new SimpleGrantedAuthority(groupToAuthorityMapEntry.getValue()));
        }
        return authorities;
    }

    private List<GrantedAuthority> generateAuthoritiesFromGroupNames(List userGroups) {
        ArrayList<GrantedAuthority> authorities = new ArrayList<GrantedAuthority>();
        Iterator iterator = userGroups.iterator();
        while (iterator.hasNext()) {
            authorities.add((GrantedAuthority)new SimpleGrantedAuthority(this.getAuthorityPrefix() + iterator.next()));
        }
        return authorities;
    }

    @Override
    public String getAuthorityPrefix() {
        return this.authorityPrefix;
    }

    @Override
    public void setAuthorityPrefix(String authorityPrefix) {
        this.authorityPrefix = authorityPrefix;
    }

    @Override
    public Iterable<Map.Entry<String, String>> getGroupToAuthorityMappings() {
        return this.groupToAuthorityMappings;
    }

    @Override
    public void setGroupToAuthorityMappings(Iterable<Map.Entry<String, String>> groupToAuthorityMappings) {
        this.groupToAuthorityMappings = groupToAuthorityMappings;
    }

    public void setUserAuthoritiesProvider(UserAuthoritiesProvider userAuthoritiesProvider) {
        this.userAuthoritiesProvider = userAuthoritiesProvider;
    }

    @Override
    public String getAdminAuthority() {
        return this.adminAuthority;
    }

    @Override
    public void setAdminAuthority(String adminAuthority) {
        this.adminAuthority = adminAuthority;
    }

    public void setUserManager(UserManager userManager) {
        this.userManager = userManager;
    }

    public void setGroupMembershipManager(GroupMembershipManager groupMembershipManager) {
        this.groupMembershipManager = groupMembershipManager;
    }
}

