/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.springsecurity;

import com.atlassian.crowd.integration.http.HttpAuthenticator;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.logout.LogoutHandler;

public class CrowdLogoutHandler
implements LogoutHandler {
    private static final Log logger = LogFactory.getLog(CrowdLogoutHandler.class);
    private HttpAuthenticator httpAuthenticator;

    public void logout(HttpServletRequest request, HttpServletResponse response, Authentication authentication) {
        try {
            this.httpAuthenticator.logoff(request, response);
        }
        catch (Exception e) {
            logger.error((Object)"Could not logout SSO user from Crowd", (Throwable)e);
        }
    }

    public HttpAuthenticator getHttpAuthenticator() {
        return this.httpAuthenticator;
    }

    public void setHttpAuthenticator(HttpAuthenticator httpAuthenticator) {
        this.httpAuthenticator = httpAuthenticator;
    }
}

