/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.springsecurity;

import com.atlassian.crowd.integration.springsecurity.RequestToApplicationMapper;
import com.atlassian.crowd.service.client.ClientProperties;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.servlet.http.HttpServletRequest;
import org.springframework.security.ui.savedrequest.SavedRequest;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.Assert;

public class RequestToApplicationMapperImpl
implements RequestToApplicationMapper {
    private final ClientProperties clientProperties;
    private final Map<String, String> pathToApplicationMap;
    private final AntPathMatcher pathMatcher;
    private ReadWriteLock readWriteLock;

    public RequestToApplicationMapperImpl(ClientProperties clientProperties) {
        this.clientProperties = clientProperties;
        this.pathToApplicationMap = new LinkedHashMap<String, String>();
        this.pathMatcher = new AntPathMatcher();
        this.readWriteLock = new ReentrantReadWriteLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getApplication(String path) {
        Assert.notNull((Object)path, (String)"Path cannot be null");
        this.readWriteLock.readLock().lock();
        try {
            for (Map.Entry<String, String> entry : this.pathToApplicationMap.entrySet()) {
                if (!this.pathMatcher.match(entry.getKey(), path)) continue;
                String string = entry.getValue();
                return string;
            }
            String string = this.clientProperties.getApplicationName();
            return string;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    public String getApplication(HttpServletRequest request) {
        SavedRequest savedRequest = (SavedRequest)request.getSession().getAttribute("SPRING_SECURITY_SAVED_REQUEST_KEY");
        String path = savedRequest != null ? savedRequest.getRequestURI().substring(savedRequest.getContextPath().length()) : request.getRequestURI().substring(request.getContextPath().length());
        return this.getApplication(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSecureMapping(String path, String applicationName) {
        Assert.notNull((Object)path, (String)"Path to add cannot be null");
        Assert.notNull((Object)applicationName, (String)"Application name to add cannot be null");
        this.readWriteLock.writeLock().lock();
        try {
            this.pathToApplicationMap.put(path, applicationName);
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSecureMapping(String path) {
        Assert.notNull((Object)path, (String)"Path to remove cannot be null");
        this.readWriteLock.writeLock().lock();
        try {
            this.pathToApplicationMap.remove(path);
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllMappings(String applicationName) {
        Assert.notNull((Object)applicationName, (String)"Application name cannot be null");
        this.readWriteLock.writeLock().lock();
        try {
            Iterator<Map.Entry<String, String>> entries = this.pathToApplicationMap.entrySet().iterator();
            while (entries.hasNext()) {
                Map.Entry<String, String> entry = entries.next();
                if (!entry.getValue().equals(applicationName)) continue;
                entries.remove();
            }
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }
}

