/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.springsecurity.user;

import com.atlassian.crowd.integration.soap.SOAPAttribute;
import com.atlassian.crowd.integration.soap.SOAPPrincipal;
import org.springframework.security.GrantedAuthority;
import org.springframework.security.userdetails.UserDetails;

public class CrowdUserDetails
implements UserDetails {
    private SOAPPrincipal principal;
    private GrantedAuthority[] authorities;

    public CrowdUserDetails(SOAPPrincipal principal, GrantedAuthority[] authorities) {
        this.principal = principal;
        this.authorities = authorities;
    }

    public GrantedAuthority[] getAuthorities() {
        return this.authorities;
    }

    public SOAPPrincipal getRemotePrincipal() {
        return this.principal;
    }

    public String getPassword() {
        throw new UnsupportedOperationException("Not giving you the password");
    }

    public String getUsername() {
        return this.principal.getName();
    }

    public boolean isAccountNonExpired() {
        return true;
    }

    public boolean isAccountNonLocked() {
        return true;
    }

    public boolean isCredentialsNonExpired() {
        return true;
    }

    public boolean isEnabled() {
        return this.principal.isActive();
    }

    public String getFirstName() {
        return this.getFirstAttributeValue("givenName", this.principal);
    }

    public String getLastName() {
        return this.getFirstAttributeValue("sn", this.principal);
    }

    public String getEmail() {
        return this.getFirstAttributeValue("mail", this.principal);
    }

    public String getAttribute(String attributeName) {
        return this.getFirstAttributeValue(attributeName, this.principal);
    }

    public String getFullName() {
        return this.getFirstAttributeValue("displayName", this.principal);
    }

    private String getFirstAttributeValue(String name, SOAPPrincipal principal) {
        SOAPAttribute attribute = this.getAttribute(name, principal);
        if (attribute != null && attribute.getValues() != null && attribute.getValues().length > 0) {
            return attribute.getValues()[0];
        }
        return null;
    }

    private SOAPAttribute getAttribute(String name, SOAPPrincipal principal) {
        SOAPAttribute[] attributes = principal.getAttributes();
        if (attributes != null) {
            for (SOAPAttribute attribute : attributes) {
                if (!attribute.getName().equals(name)) continue;
                return attribute;
            }
        }
        return null;
    }
}

