/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.springsecurity;

import com.atlassian.crowd.integration.http.CrowdHttpAuthenticator;
import com.atlassian.crowd.integration.http.util.CrowdHttpTokenHelper;
import com.atlassian.crowd.integration.springsecurity.CrowdSSOAuthenticationDetails;
import com.atlassian.crowd.integration.springsecurity.CrowdSSOAuthenticationToken;
import com.atlassian.crowd.service.client.ClientProperties;
import com.atlassian.crowd.service.client.CrowdClient;
import java.io.IOException;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.LoginUrlAuthenticationEntryPoint;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;

public class CrowdSSOAuthenticationProcessingFilter
extends UsernamePasswordAuthenticationFilter {
    private static final Logger logger = LoggerFactory.getLogger(CrowdSSOAuthenticationProcessingFilter.class);
    private final CrowdHttpTokenHelper tokenHelper;
    private final CrowdClient crowdClient;
    private final ClientProperties clientProperties;
    private CrowdHttpAuthenticator httpAuthenticator;
    private LoginUrlAuthenticationEntryPoint authenticationProcessingFilterEntryPoint;

    public CrowdSSOAuthenticationProcessingFilter(CrowdHttpTokenHelper tokenHelper, CrowdClient crowdClient, ClientProperties clientProperties) {
        this.tokenHelper = tokenHelper;
        this.crowdClient = crowdClient;
        this.clientProperties = clientProperties;
    }

    protected boolean requiresAuthentication(HttpServletRequest request, HttpServletResponse response) {
        boolean usernamePasswordAuthentication = super.requiresAuthentication(request, response);
        if (!usernamePasswordAuthentication) {
            Authentication authenticatedToken = null;
            try {
                String token = this.httpAuthenticator.getToken(request);
                if (token != null) {
                    CrowdSSOAuthenticationToken crowdAuthRequest = new CrowdSSOAuthenticationToken(token);
                    this.doSetDetails(request, crowdAuthRequest);
                    authenticatedToken = this.getAuthenticationManager().authenticate((Authentication)crowdAuthRequest);
                }
            }
            catch (AuthenticationException authenticationException) {
                // empty catch block
            }
            if (authenticatedToken == null) {
                SecurityContextHolder.clearContext();
            } else {
                SecurityContextHolder.getContext().setAuthentication(authenticatedToken);
                this.storeTokenIfCrowd(request, response, authenticatedToken);
            }
        }
        return usernamePasswordAuthentication;
    }

    protected void setDetails(HttpServletRequest request, UsernamePasswordAuthenticationToken authRequest) {
        this.doSetDetails(request, (AbstractAuthenticationToken)authRequest);
    }

    static String requestUriWithoutContext(HttpServletRequest request) {
        return request.getRequestURI().substring(request.getContextPath().length());
    }

    boolean canUseSavedRequestToAuthenticate(HttpServletRequest request) {
        if (super.requiresAuthentication(request, null)) {
            return true;
        }
        if (this.authenticationProcessingFilterEntryPoint != null) {
            String loginFormUrl = this.authenticationProcessingFilterEntryPoint.getLoginFormUrl();
            return CrowdSSOAuthenticationProcessingFilter.requestUriWithoutContext(request).equals(loginFormUrl);
        }
        return false;
    }

    protected void doSetDetails(HttpServletRequest request, AbstractAuthenticationToken authRequest) {
        List validationFactors = this.tokenHelper.getValidationFactorExtractor().getValidationFactors(request);
        authRequest.setDetails((Object)new CrowdSSOAuthenticationDetails(validationFactors));
    }

    private void storeTokenIfCrowd(HttpServletRequest request, HttpServletResponse response, Authentication authResult) {
        if (authResult instanceof CrowdSSOAuthenticationToken && authResult.getCredentials() != null) {
            try {
                this.tokenHelper.setCrowdToken(request, response, (String)authResult.getCredentials(), this.clientProperties, this.crowdClient.getCookieConfiguration());
            }
            catch (Exception e) {
                logger.error("Unable to set Crowd SSO token", (Throwable)e);
            }
        }
    }

    protected void successfulAuthentication(HttpServletRequest request, HttpServletResponse response, Authentication authResult) throws IOException, ServletException {
        this.storeTokenIfCrowd(request, response, authResult);
        super.successfulAuthentication(request, response, authResult);
    }

    protected void unsuccessfulAuthentication(HttpServletRequest request, HttpServletResponse response, AuthenticationException failed) throws IOException, ServletException {
        try {
            this.httpAuthenticator.logout(request, response);
        }
        catch (Exception e) {
            logger.error("Unable to unset Crowd SSO token", (Throwable)e);
        }
        super.unsuccessfulAuthentication(request, response, failed);
    }

    public void setHttpAuthenticator(CrowdHttpAuthenticator httpAuthenticator) {
        this.httpAuthenticator = httpAuthenticator;
    }

    public void setLoginUrlAuthenticationEntryPoint(LoginUrlAuthenticationEntryPoint filterEntryPoint) {
        this.authenticationProcessingFilterEntryPoint = filterEntryPoint;
    }
}

