/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.osuser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PropertyParser {
    private final Pattern pattern;

    public PropertyParser(String prefix) {
        this.pattern = Pattern.compile(prefix + "(\\p{Alnum})*(-(.*))?");
    }

    public List parse(Properties properties) {
        List validProperties = this.filterAndSortValidProperties(properties);
        ArrayList<ResultImpl> result = new ArrayList<ResultImpl>();
        String currentKey = "";
        Properties currentProperties = null;
        for (ValueHolder value : validProperties) {
            if (!currentKey.equals(value.pair.getKey())) {
                Class<?> clazz;
                if (value.getPair().hasSuffix()) continue;
                currentKey = value.pair.getKey();
                Properties resultProperties = currentProperties = new Properties();
                try {
                    clazz = Class.forName(value.value);
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
                ResultImpl currentResult = new ResultImpl(clazz, resultProperties);
                result.add(currentResult);
                continue;
            }
            if (currentProperties == null) {
                throw new IllegalStateException("Parsing error: Received an empty property");
            }
            currentProperties.put(value.getPropertyName(), value.getValue());
        }
        return result;
    }

    protected List filterAndSortValidProperties(Properties properties) {
        ArrayList<Object> keys = new ArrayList<Object>(new TreeSet<Object>(properties.keySet()));
        ArrayList<ValueHolder> validProperties = new ArrayList<ValueHolder>();
        for (String string : keys) {
            Pair pair = this.parseKey(string);
            if (pair == null) continue;
            validProperties.add(new ValueHolder(pair, (String)properties.get(string)));
        }
        Collections.sort(validProperties);
        return validProperties;
    }

    public Pair parseKey(String key) {
        Matcher matcher = this.pattern.matcher(key);
        if (!matcher.find()) {
            return null;
        }
        return new Pair(matcher.group(1), matcher.group(3));
    }

    protected static class ValueHolder
    implements Comparable {
        private final Pair pair;
        private final String value;

        public ValueHolder(Pair key, String value) {
            if (key == null) {
                throw new NullPointerException("Key must not be null");
            }
            if (value == null) {
                throw new NullPointerException("Value must not be null");
            }
            this.pair = key;
            this.value = value;
        }

        public Pair getPair() {
            return this.pair;
        }

        public String getPropertyName() {
            return this.pair.getSuffix();
        }

        public String getValue() {
            return this.value;
        }

        public int compareTo(Object o) {
            return this.pair.compareTo(((ValueHolder)o).pair);
        }

        public int hashCode() {
            return 37 * this.pair.hashCode() + this.value.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof ValueHolder)) {
                return false;
            }
            ValueHolder vh = (ValueHolder)obj;
            return this.pair.equals(vh.getPair()) && this.value.equals(vh.getValue());
        }

        public String toString() {
            return this.pair + ":" + this.value;
        }
    }

    public static class Pair
    implements Comparable {
        private final String key;
        private final String suffix;

        public Pair(String key, String suffix) {
            if (key == null) {
                throw new NullPointerException("Key must not be null");
            }
            this.key = key;
            this.suffix = suffix == null ? "" : suffix;
        }

        public String getKey() {
            return this.key;
        }

        public String getSuffix() {
            return this.suffix;
        }

        public boolean hasSuffix() {
            return !"".equals(this.suffix);
        }

        public int compareTo(Object o) {
            if (o == null) {
                return 1;
            }
            if (!(o instanceof Pair)) {
                throw new IllegalArgumentException("Pair can be only compared with another Pair");
            }
            Pair p = (Pair)o;
            if (!this.key.equals(p.getKey())) {
                return this.key.compareTo(p.getKey());
            }
            return this.suffix.compareTo(p.getSuffix());
        }

        public int hashCode() {
            return 37 * this.key.hashCode() + this.suffix.hashCode();
        }

        public boolean equals(Object obj) {
            return this.compareTo(obj) == 0;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer(this.key);
            if (this.hasSuffix()) {
                sb.append("-");
                sb.append(this.suffix);
            }
            return sb.toString();
        }
    }

    static class ResultImpl
    implements Result {
        private final Class clazz;
        private final Properties properties;

        public ResultImpl(Class clazz, Properties properties) {
            this.clazz = clazz;
            this.properties = properties;
        }

        @Override
        public Class getParsedClass() {
            return this.clazz;
        }

        @Override
        public Properties getProperties() {
            return this.properties;
        }

        @Override
        public String getProperty(String key) {
            return this.properties.getProperty(key);
        }
    }

    public static interface Result {
        public Class getParsedClass();

        public Properties getProperties();

        public String getProperty(String var1);
    }
}

