/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.jive;

import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.jivesoftware.base.AuthToken;
import com.jivesoftware.base.Group;
import com.jivesoftware.base.GroupManagerFactory;
import com.jivesoftware.base.GroupNotFoundException;
import com.jivesoftware.base.Log;
import com.jivesoftware.base.Permissions;
import com.jivesoftware.base.UnauthorizedException;
import com.jivesoftware.base.User;
import com.jivesoftware.base.database.ConnectionManager;
import com.jivesoftware.base.database.sequence.SequenceManager;
import com.jivesoftware.util.CacheSizes;
import com.jivesoftware.util.Cacheable;
import com.jivesoftware.util.StringUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class CrowdGroup
implements Group,
Cacheable {
    private static final String LOAD_PROPERTIES = "SELECT name, propValue FROM jiveGroupProp WHERE groupID=?";
    private static final String DELETE_PROPERTY = "DELETE FROM jiveGroupProp WHERE groupID=? AND name=?";
    private static final String UPDATE_PROPERTY = "UPDATE jiveGroupProp SET propValue=? WHERE name=? AND groupID=?";
    private static final String INSERT_PROPERTY = "INSERT INTO jiveGroupProp(groupID, name, propValue) VALUES(?, ?, ?)";
    private static final String INSERT_GROUP = "INSERT INTO jiveGroup (groupID, name, description, creationDate, modificationDate) VALUES (?, ?, '-', ?, ?)";
    private static final String LOAD_GROUP_BY_ID = "SELECT groupID, name, description, creationDate, modificationDate FROM jiveGroup WHERE groupID=?";
    private static final String LOAD_GROUP_BY_NAME = "SELECT groupID, name, description, creationDate, modificationDate FROM jiveGroup WHERE name=?";
    private long ID = -1L;
    private String name = null;
    private String description = null;
    private Date creationDate = null;
    private Date modificationDate = null;
    private List members = null;
    private Map properties = new Hashtable();

    protected CrowdGroup(String name, String description, List members) {
        Log.debug((String)("Attempting to create CrowdGroup given name: " + name));
        this.name = name;
        try {
            this.loadFromDb();
        }
        catch (GroupNotFoundException e) {
            this.ID = SequenceManager.nextID((int)4);
            long now = System.currentTimeMillis();
            this.creationDate = new Date(now);
            this.modificationDate = new Date(now);
            this.properties = new Hashtable();
            if (this.name != null) {
                this.name = IdentifierUtils.toLowerCase(this.name);
            }
            this.insertIntoDb();
        }
        this.description = description;
        this.members = members;
        GroupManagerFactory.groupCache.put((Object)new Long(this.ID), (Object)this);
        GroupManagerFactory.groupIDCache.put((Object)this.name, (Object)new Long(this.ID));
    }

    protected CrowdGroup(long ID) throws GroupNotFoundException {
        Log.debug((String)("Attempting to create CrowdGroup given ID: " + ID));
        this.ID = ID;
        this.loadFromDb();
    }

    public long getID() {
        return this.ID;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) throws UnauthorizedException {
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) throws UnauthorizedException {
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Date creationDate) throws UnauthorizedException {
    }

    public Date getModificationDate() {
        return this.modificationDate;
    }

    public void setModificationDate(Date modificationDate) throws UnauthorizedException {
    }

    public String getProperty(String name) {
        if (name == null) {
            return null;
        }
        String value = (String)this.properties.get(name);
        return StringUtils.escapeHTMLTags((String)value);
    }

    public void setProperty(String name, String value) throws UnauthorizedException {
        if (name == null || value == null || "".equals(name) || "".equals(value)) {
            throw new NullPointerException("Cannot set property with empty or null value.");
        }
        if (this.properties.containsKey(name)) {
            if (!value.equals(this.properties.get(name))) {
                this.properties.put(name, value);
                this.updatePropertyInDb(name, value);
            }
        } else {
            this.properties.put(name, value);
            this.insertPropertyIntoDb(name, value);
        }
        GroupManagerFactory.groupCache.put((Object)new Long(this.ID), (Object)this);
    }

    public void deleteProperty(String name) throws UnauthorizedException {
        if (this.properties.containsKey(name)) {
            this.properties.remove(name);
            this.deletePropertyFromDb(name);
            GroupManagerFactory.groupCache.put((Object)new Long(this.ID), (Object)this);
        }
    }

    public Iterator getPropertyNames() {
        return this.properties.keySet().iterator();
    }

    public void addAdministrator(User user) throws UnauthorizedException {
        throw new UnsupportedOperationException("Adding administrators is not supported.");
    }

    public void removeAdministrator(User user) throws UnauthorizedException {
        throw new UnsupportedOperationException("Removing administrators is not supported.");
    }

    public void addMember(User user) throws UnauthorizedException {
        throw new UnsupportedOperationException("Adding members is not supported.");
    }

    public void removeMember(User user) throws UnauthorizedException {
        throw new UnsupportedOperationException("Removing members is not supported.");
    }

    public boolean isAdministrator(User user) {
        return false;
    }

    public boolean isMember(User user) {
        if (this.members == null) {
            return false;
        }
        return this.members.contains(user);
    }

    public int getAdministratorCount() {
        return 0;
    }

    public int getMemberCount() {
        if (this.members == null) {
            return 0;
        }
        return this.members.size();
    }

    public Iterator getMembers() {
        if (this.members == null) {
            return Collections.EMPTY_SET.iterator();
        }
        return this.members.iterator();
    }

    public Iterator getAdministrators() {
        return Collections.EMPTY_LIST.iterator();
    }

    public Permissions getPermissions(AuthToken auth) {
        return new Permissions(0L);
    }

    public boolean isAuthorized(long permissionType) {
        return true;
    }

    public int getCachedSize() {
        int size = 0;
        size += CacheSizes.sizeOfObject();
        size += CacheSizes.sizeOfLong();
        size += CacheSizes.sizeOfString((String)this.name);
        size += CacheSizes.sizeOfString((String)this.description);
        size += CacheSizes.sizeOfMap((Map)this.properties);
        size += CacheSizes.sizeOfList((List)this.members);
        size += CacheSizes.sizeOfDate();
        return size += CacheSizes.sizeOfDate();
    }

    public String toString() {
        return this.name;
    }

    public int hashCode() {
        return (int)this.ID;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object != null && object instanceof Group) {
            return this.ID == ((Group)object).getID();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertPropertyIntoDb(String name, String value) {
        Connection con = null;
        PreparedStatement pstmt = null;
        boolean abortTransaction = false;
        try {
            con = ConnectionManager.getTransactionConnection();
            pstmt = con.prepareStatement(INSERT_PROPERTY);
            pstmt.setLong(1, this.ID);
            pstmt.setString(2, name);
            pstmt.setString(3, value);
            pstmt.executeUpdate();
        }
        catch (SQLException sqle) {
            Log.error((Throwable)sqle);
            abortTransaction = true;
        }
        finally {
            ConnectionManager.closeTransactionConnection((PreparedStatement)pstmt, (Connection)con, (boolean)abortTransaction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updatePropertyInDb(String name, String value) {
        Connection con = null;
        PreparedStatement pstmt = null;
        boolean abortTransaction = false;
        try {
            con = ConnectionManager.getTransactionConnection();
            pstmt = con.prepareStatement(UPDATE_PROPERTY);
            pstmt.setString(1, value);
            pstmt.setString(2, name);
            pstmt.setLong(3, this.ID);
            pstmt.executeUpdate();
        }
        catch (SQLException sqle) {
            Log.error((Throwable)sqle);
            abortTransaction = true;
        }
        finally {
            ConnectionManager.closeTransactionConnection((PreparedStatement)pstmt, (Connection)con, (boolean)abortTransaction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void deletePropertyFromDb(String name) {
        Connection con = null;
        PreparedStatement pstmt = null;
        boolean abortTransaction = false;
        try {
            con = ConnectionManager.getTransactionConnection();
            pstmt = con.prepareStatement(DELETE_PROPERTY);
            pstmt.setLong(1, this.ID);
            pstmt.setString(2, name);
            pstmt.execute();
        }
        catch (SQLException sqle) {
            Log.error((Throwable)sqle);
            abortTransaction = true;
        }
        finally {
            ConnectionManager.closeTransactionConnection((PreparedStatement)pstmt, (Connection)con, (boolean)abortTransaction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertIntoDb() {
        PreparedStatement pstmt;
        Connection con;
        block5: {
            Log.debug((String)("Inserting group into jive DB with name: " + this.name));
            con = null;
            pstmt = null;
            try {
                con = ConnectionManager.getConnection();
                pstmt = con.prepareStatement(INSERT_GROUP);
                pstmt.setLong(1, this.ID);
                pstmt.setString(2, this.name);
                pstmt.setLong(3, this.creationDate.getTime());
                pstmt.setLong(4, this.modificationDate.getTime());
                pstmt.executeUpdate();
                if (this.properties.size() <= 0) break block5;
                pstmt.close();
                pstmt = con.prepareStatement(INSERT_PROPERTY);
                for (String name : this.properties.keySet()) {
                    String value = (String)this.properties.get(name);
                    pstmt.setLong(1, this.ID);
                    pstmt.setString(2, name);
                    pstmt.setString(3, value);
                    pstmt.executeUpdate();
                }
            }
            catch (SQLException sqle) {
                try {
                    Log.error((Throwable)sqle);
                }
                catch (Throwable throwable) {
                    ConnectionManager.closeConnection(pstmt, (Connection)con);
                    throw throwable;
                }
                ConnectionManager.closeConnection((PreparedStatement)pstmt, (Connection)con);
            }
        }
        ConnectionManager.closeConnection((PreparedStatement)pstmt, (Connection)con);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadFromDb() throws GroupNotFoundException {
        Log.debug((String)"Loading group from Jive DB...");
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            con = ConnectionManager.getConnection();
            if (this.name != null) {
                this.name = IdentifierUtils.toLowerCase(this.name);
                Log.debug((String)("Running query: SELECT groupID, name, description, creationDate, modificationDate FROM jiveGroup WHERE name=?, name: " + this.name));
                pstmt = con.prepareStatement(LOAD_GROUP_BY_NAME);
                pstmt.setString(1, this.name);
            } else {
                Log.debug((String)("Running query: SELECT groupID, name, description, creationDate, modificationDate FROM jiveGroup WHERE groupID=?, id: " + this.ID));
                pstmt = con.prepareStatement(LOAD_GROUP_BY_ID);
                pstmt.setLong(1, this.ID);
            }
            rs = pstmt.executeQuery();
            if (!rs.next()) {
                if (this.name != null) {
                    Log.debug((String)("Failed to load group " + this.name + " from Jive DB"));
                    throw new GroupNotFoundException("Failed to read group " + this.name + " from database.");
                }
                Log.debug((String)("Failed to load group " + this.ID + " from Jive DB"));
                throw new GroupNotFoundException("Failed to read group with ID " + this.ID + " from database.");
            }
            this.ID = rs.getLong(1);
            this.name = rs.getString(2);
            this.description = rs.getString(3);
            this.creationDate = new Date(rs.getLong(4));
            this.modificationDate = new Date(rs.getLong(5));
            rs.close();
            pstmt.close();
            this.properties = new Hashtable();
            pstmt = con.prepareStatement(LOAD_PROPERTIES);
            pstmt.setLong(1, this.ID);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                this.properties.put(rs.getString(1), rs.getString(2));
            }
            rs.close();
        }
        catch (SQLException sqle) {
            try {
                Log.debug((String)("Failed to load group from DB, SQL exception: " + sqle));
                throw new GroupNotFoundException("Failed to read group " + this.ID + " from database.", (Throwable)sqle);
                catch (NumberFormatException nfe) {
                    Log.error((String)"WARNING: There was an error parsing the dates returned from the database. Ensure that they're being stored correctly.");
                    throw new GroupNotFoundException("Group with id " + this.ID + " could not be loaded from the database.");
                }
            }
            catch (Throwable throwable) {
                ConnectionManager.closeConnection(rs, pstmt, (Connection)con);
                throw throwable;
            }
        }
        ConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
    }
}

