/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.atlassianuser;

import com.atlassian.crowd.exception.InvalidAuthenticationException;
import com.atlassian.crowd.exception.InvalidAuthorizationTokenException;
import com.atlassian.crowd.integration.atlassianuser.CrowdUser;
import com.atlassian.crowd.integration.soap.SOAPGroup;
import com.atlassian.crowd.integration.soap.SOAPPrincipal;
import com.atlassian.crowd.integration.soap.SearchRestriction;
import com.atlassian.crowd.service.GroupManager;
import com.atlassian.crowd.service.UserManager;
import com.atlassian.crowd.service.cache.CachingManagerFactory;
import com.atlassian.user.EntityException;
import com.atlassian.user.Group;
import com.atlassian.user.User;
import com.atlassian.user.impl.DefaultGroup;
import com.atlassian.user.repository.RepositoryIdentifier;
import com.atlassian.user.search.DefaultSearchResult;
import com.atlassian.user.search.SearchResult;
import com.atlassian.user.search.page.DefaultPager;
import com.atlassian.user.search.page.Pager;
import com.atlassian.user.search.query.BooleanQuery;
import com.atlassian.user.search.query.EmailTermQuery;
import com.atlassian.user.search.query.EntityQueryException;
import com.atlassian.user.search.query.EntityQueryParser;
import com.atlassian.user.search.query.FullNameTermQuery;
import com.atlassian.user.search.query.GroupNameTermQuery;
import com.atlassian.user.search.query.Query;
import com.atlassian.user.search.query.QueryContext;
import com.atlassian.user.search.query.TermQuery;
import com.atlassian.user.search.query.UserNameTermQuery;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrowdEntityQueryParser
implements EntityQueryParser {
    private static final Logger logger = LoggerFactory.getLogger(CrowdEntityQueryParser.class);
    private final com.atlassian.user.UserManager userManager;
    private final com.atlassian.user.GroupManager groupManager;
    private final RepositoryIdentifier repositoryIdentifier;
    private final UserManager crowdUserManager;
    private final GroupManager crowdGroupManager;

    public CrowdEntityQueryParser(com.atlassian.user.UserManager userManager, com.atlassian.user.GroupManager groupManager, RepositoryIdentifier repositoryIdentifier) {
        this(userManager, groupManager, repositoryIdentifier, CachingManagerFactory.getUserManagerInstance(), CachingManagerFactory.getGroupManagerInstance());
    }

    public CrowdEntityQueryParser(com.atlassian.user.UserManager userManager, com.atlassian.user.GroupManager groupManager, RepositoryIdentifier repositoryIdentifier, UserManager crowdUserManager, GroupManager crowdGroupManager) {
        this.userManager = userManager;
        this.groupManager = groupManager;
        this.repositoryIdentifier = repositoryIdentifier;
        this.crowdUserManager = crowdUserManager;
        this.crowdGroupManager = crowdGroupManager;
    }

    public SearchResult findGroups(Query query) throws EntityException {
        if (query instanceof GroupNameTermQuery) {
            DefaultSearchResult results;
            GroupNameTermQuery groupQuery = (GroupNameTermQuery)query;
            if (groupQuery.getTerm().equals("")) {
                Pager allUsers = this.groupManager.getGroups();
                results = new DefaultSearchResult(allUsers, this.repositoryIdentifier.getKey());
            } else {
                try {
                    List<Group> groups = this.searchGroups(groupQuery);
                    DefaultPager pager = new DefaultPager(groups);
                    results = new DefaultSearchResult((Pager)pager, this.repositoryIdentifier.getKey());
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    throw new EntityException(e.getMessage(), (Throwable)e);
                }
            }
            return results;
        }
        throw new EntityQueryException("Query of type " + query.getClass() + " is not supported by Crowd for group search");
    }

    protected List<Group> searchGroups(GroupNameTermQuery query) throws InvalidAuthorizationTokenException, RemoteException, InvalidAuthenticationException {
        SearchRestriction groupNameRestriction = new SearchRestriction("group.name", query.getTerm());
        SearchRestriction[] searchRestrictions = new SearchRestriction[]{groupNameRestriction};
        List soapGroups = this.crowdGroupManager.searchGroups(searchRestrictions);
        ArrayList<Group> groups = new ArrayList<Group>(soapGroups == null ? 0 : soapGroups.size());
        if (soapGroups != null) {
            for (SOAPGroup soapGroup : soapGroups) {
                groups.add((Group)new DefaultGroup(soapGroup.getName()));
            }
        }
        return groups;
    }

    public SearchResult findUsers(Query query, QueryContext context) throws EntityException {
        return this.findUsers(query);
    }

    public SearchResult findGroups(Query query, QueryContext context) throws EntityException {
        return this.findGroups(query);
    }

    protected SearchRestriction queryAsSearchRestriction(TermQuery query) throws EntityQueryException {
        String term = query.getTerm();
        SearchRestriction searchRestriction = new SearchRestriction();
        searchRestriction.setValue(term);
        if (query instanceof UserNameTermQuery) {
            searchRestriction.setName("username");
        } else if (query instanceof EmailTermQuery) {
            searchRestriction.setName("mail");
        } else if (query instanceof FullNameTermQuery) {
            searchRestriction.setName("displayName");
        } else {
            throw new EntityQueryException("Query of type " + query.getClass() + " is not supported by Crowd for user search");
        }
        return searchRestriction;
    }

    protected List<SOAPPrincipal> performUserSearch(TermQuery query) throws EntityQueryException, InvalidAuthorizationTokenException, RemoteException, InvalidAuthenticationException {
        SearchRestriction[] searchRestrictions = new SearchRestriction[]{this.queryAsSearchRestriction(query)};
        return this.crowdUserManager.searchUsers(searchRestrictions);
    }

    protected List<SOAPPrincipal> performAndUserSearch(List<TermQuery> queries) throws EntityQueryException, InvalidAuthorizationTokenException, RemoteException, InvalidAuthenticationException {
        ArrayList<SearchRestriction> searchRestrictions = new ArrayList<SearchRestriction>(queries.size());
        for (TermQuery query : queries) {
            searchRestrictions.add(this.queryAsSearchRestriction(query));
        }
        return this.crowdUserManager.searchUsers(searchRestrictions.toArray(new SearchRestriction[0]));
    }

    protected List<SOAPPrincipal> performOrUserSearch(List<TermQuery> queries) throws EntityQueryException, InvalidAuthorizationTokenException, RemoteException, InvalidAuthenticationException {
        HashSet<SOAPPrincipal> results = new HashSet<SOAPPrincipal>();
        for (TermQuery query : queries) {
            List<SOAPPrincipal> termResults = this.performUserSearch(query);
            results.addAll(termResults);
        }
        return new ArrayList<SOAPPrincipal>(results);
    }

    protected List<TermQuery> ensureAllTermQueries(List<Query> queries) throws EntityQueryException {
        ArrayList<TermQuery> result = new ArrayList<TermQuery>();
        for (Query query : queries) {
            if (!(query instanceof TermQuery)) {
                throw new EntityQueryException("Query of type " + query.getClass() + " is not supported by Crowd");
            }
            result.add((TermQuery)query);
        }
        return result;
    }

    protected List<User> searchUsers(Query query) throws EntityQueryException, InvalidAuthorizationTokenException, RemoteException, InvalidAuthenticationException {
        List<SOAPPrincipal> soapResults = null;
        if (query instanceof TermQuery) {
            soapResults = this.performUserSearch((TermQuery)query);
        } else if (query instanceof BooleanQuery) {
            BooleanQuery booleanQuery = (BooleanQuery)query;
            List<TermQuery> termQueries = this.ensureAllTermQueries(booleanQuery.getQueries());
            soapResults = booleanQuery.isAND() ? this.performAndUserSearch(termQueries) : this.performOrUserSearch(termQueries);
        } else {
            throw new EntityQueryException("Query of type " + query.getClass() + " is not supported by Crowd");
        }
        ArrayList<User> results = new ArrayList<User>(soapResults == null ? 0 : soapResults.size());
        if (soapResults != null) {
            for (SOAPPrincipal principal : soapResults) {
                CrowdUser user = new CrowdUser(principal, this.crowdUserManager);
                results.add((User)user);
            }
        }
        return results;
    }

    public SearchResult findUsers(Query query) throws EntityException {
        try {
            DefaultPager results;
            if (query instanceof UserNameTermQuery && "".equals(((UserNameTermQuery)query).getTerm())) {
                results = this.userManager.getUsers();
            } else {
                List<User> users = this.searchUsers(query);
                results = new DefaultPager(users);
            }
            return new DefaultSearchResult((Pager)results, this.repositoryIdentifier.getKey());
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new EntityException(e.getMessage(), (Throwable)e);
        }
    }
}

