/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.util;

import com.atlassian.crowd.embedded.api.UserComparator;
import com.atlassian.crowd.exception.ApplicationPermissionException;
import com.atlassian.crowd.exception.BulkAddFailedException;
import com.atlassian.crowd.exception.ExpiredCredentialException;
import com.atlassian.crowd.exception.GroupNotFoundException;
import com.atlassian.crowd.exception.InvalidAuthenticationException;
import com.atlassian.crowd.exception.InvalidAuthorizationTokenException;
import com.atlassian.crowd.exception.InvalidGroupException;
import com.atlassian.crowd.exception.MembershipNotFoundException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.integration.exception.ApplicationAccessDeniedException;
import com.atlassian.crowd.integration.exception.InactiveAccountException;
import com.atlassian.crowd.integration.exception.InvalidCredentialException;
import com.atlassian.crowd.integration.exception.InvalidEmailAddressException;
import com.atlassian.crowd.integration.exception.InvalidRoleException;
import com.atlassian.crowd.integration.exception.InvalidTokenException;
import com.atlassian.crowd.integration.exception.InvalidUserException;
import com.atlassian.crowd.integration.exception.ObjectNotFoundException;
import com.atlassian.crowd.integration.model.DirectoryEntity;
import com.atlassian.crowd.integration.model.user.User;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.group.GroupComparator;
import com.atlassian.crowd.model.group.GroupType;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SoapExceptionTranslator {
    public static void throwSoapEquivalentCheckedException(ApplicationPermissionException e) throws com.atlassian.crowd.integration.exception.ApplicationPermissionException {
        throw new com.atlassian.crowd.integration.exception.ApplicationPermissionException(e.getMessage(), e.getCause());
    }

    public static void throwSoapEquivalentCheckedException(com.atlassian.crowd.exception.ApplicationAccessDeniedException e) throws ApplicationAccessDeniedException {
        throw new ApplicationAccessDeniedException(e.getMessage(), e.getCause());
    }

    public static void throwSoapEquivalentCheckedException(BulkAddFailedException e) throws com.atlassian.crowd.integration.exception.BulkAddFailedException {
        throw new com.atlassian.crowd.integration.exception.BulkAddFailedException(e.getMessage(), e.getFailedUsers(), e.getExistingUsers(), e.getCause());
    }

    public static void throwSoapEquivalentCheckedException(InvalidAuthorizationTokenException e) throws com.atlassian.crowd.integration.exception.InvalidAuthorizationTokenException {
        throw new com.atlassian.crowd.integration.exception.InvalidAuthorizationTokenException(e.getMessage(), e.getCause());
    }

    public static void throwSoapEquivalentCheckedException(com.atlassian.crowd.exception.InvalidEmailAddressException e) throws InvalidEmailAddressException {
        throw new InvalidEmailAddressException(e.getMessage(), e.getCause());
    }

    public static void throwSoapEquivalentCheckedException(com.atlassian.crowd.exception.InvalidTokenException e) throws InvalidTokenException {
        throw new InvalidTokenException(e.getMessage(), e.getCause());
    }

    public static void throwSoapEquivalentCheckedException(ExpiredCredentialException e) throws com.atlassian.crowd.integration.exception.ExpiredCredentialException {
        throw new com.atlassian.crowd.integration.exception.ExpiredCredentialException(e.getMessage(), e.getCause());
    }

    public static void throwSoapEquivalentCheckedException(com.atlassian.crowd.exception.InactiveAccountException e) throws InactiveAccountException {
        User user = SoapExceptionTranslator.toSoapIntegrationUser(e.getName());
        throw new InactiveAccountException(user, e.getCause());
    }

    public static void throwSoapEquivalentCheckedException(InvalidAuthenticationException e) throws com.atlassian.crowd.integration.exception.InvalidAuthenticationException {
        throw new com.atlassian.crowd.integration.exception.InvalidAuthenticationException(e.getMessage(), e.getCause());
    }

    public static void throwSoapEquivalentCheckedException(com.atlassian.crowd.exception.InvalidCredentialException e) throws InvalidCredentialException {
        throw new InvalidCredentialException(e.getMessage(), e.getCause());
    }

    public static void throwSoapEquivalentCheckedException(InvalidGroupException e) throws com.atlassian.crowd.integration.exception.InvalidGroupException {
        throw new com.atlassian.crowd.integration.exception.InvalidGroupException(SoapExceptionTranslator.toDirectoryEntity(e.getGroup()), e.getCause());
    }

    public static void throwSoapEquivalentCheckedException(com.atlassian.crowd.exception.InvalidRoleException e) throws InvalidRoleException {
        throw new InvalidRoleException(SoapExceptionTranslator.toDirectoryEntity(e.getGroup()), e.getCause());
    }

    public static void throwSoapEquivalentCheckedException(com.atlassian.crowd.exception.InvalidUserException e) throws InvalidUserException {
        throw new InvalidUserException(SoapExceptionTranslator.toDirectoryEntity(e.getUser()), e.getCause());
    }

    public static void throwSoapEquivalentCheckedException(com.atlassian.crowd.exception.ObjectNotFoundException e) throws ObjectNotFoundException {
        throw new ObjectNotFoundException(e.getMessage(), e.getCause());
    }

    public static void throwSoapEquivalentCheckedException(GroupNotFoundException e) throws ObjectNotFoundException {
        throw new ObjectNotFoundException(GroupNotFoundException.class.getName() + " " + e.getMessage(), e.getCause());
    }

    public static void throwSoapEquivalentCheckedException(UserNotFoundException e) throws ObjectNotFoundException {
        throw new ObjectNotFoundException(UserNotFoundException.class.getName() + " " + e.getMessage(), e.getCause());
    }

    public static void throwSoapEquivalentCheckedException(MembershipNotFoundException e) throws ObjectNotFoundException {
        throw new ObjectNotFoundException(MembershipNotFoundException.class.getName() + " " + e.getMessage(), e.getCause());
    }

    public static void throwEquivalentCheckedException(com.atlassian.crowd.integration.exception.ApplicationPermissionException e) throws ApplicationPermissionException {
        throw new ApplicationPermissionException(e.getMessage(), e.getCause());
    }

    public static void throwEquivalentCheckedException(ApplicationAccessDeniedException e) throws com.atlassian.crowd.exception.ApplicationAccessDeniedException {
        throw new com.atlassian.crowd.exception.ApplicationAccessDeniedException(e.getMessage(), e.getCause());
    }

    public static void throwEquivalentCheckedException(com.atlassian.crowd.integration.exception.BulkAddFailedException e) throws BulkAddFailedException {
        throw new BulkAddFailedException(e.getMessage(), e.getFailedUsers(), e.getExistingUsers(), e.getCause());
    }

    public static void throwEquivalentCheckedException(com.atlassian.crowd.integration.exception.InvalidAuthorizationTokenException e) throws InvalidAuthorizationTokenException {
        throw new InvalidAuthorizationTokenException(e.getMessage(), e.getCause());
    }

    public static void throwEquivalentCheckedException(InvalidEmailAddressException e) throws com.atlassian.crowd.exception.InvalidEmailAddressException {
        throw new com.atlassian.crowd.exception.InvalidEmailAddressException(e.getMessage(), e.getCause());
    }

    public static void throwEquivalentCheckedException(InvalidTokenException e) throws com.atlassian.crowd.exception.InvalidTokenException {
        throw new com.atlassian.crowd.exception.InvalidTokenException(e.getMessage(), e.getCause());
    }

    public static void throwEquivalentCheckedException(com.atlassian.crowd.integration.exception.ExpiredCredentialException e) throws ExpiredCredentialException {
        throw new ExpiredCredentialException(e.getMessage(), e.getCause());
    }

    public static void throwEquivalentCheckedException(InactiveAccountException e) throws com.atlassian.crowd.exception.InactiveAccountException {
        throw new com.atlassian.crowd.exception.InactiveAccountException(e.getUser().getName(), e.getCause());
    }

    public static void throwEquivalentCheckedException(com.atlassian.crowd.integration.exception.InvalidAuthenticationException e) throws InvalidAuthenticationException {
        String userName = SoapExceptionTranslator.extractEntityName(e.getMessage());
        throw new InvalidAuthenticationException(userName, e.getCause());
    }

    public static void throwEquivalentCheckedException(InvalidCredentialException e) throws com.atlassian.crowd.exception.InvalidCredentialException {
        throw new com.atlassian.crowd.exception.InvalidCredentialException(e.getMessage(), e.getCause());
    }

    public static void throwEquivalentCheckedException(com.atlassian.crowd.integration.exception.InvalidGroupException e) throws InvalidGroupException {
        throw new InvalidGroupException(SoapExceptionTranslator.toModelGroup(e.getEntity(), GroupType.GROUP), e.getCause());
    }

    public static void throwEquivalentCheckedException(InvalidRoleException e) throws com.atlassian.crowd.exception.InvalidRoleException {
        throw new com.atlassian.crowd.exception.InvalidRoleException(SoapExceptionTranslator.toModelGroup(e.getEntity(), GroupType.LEGACY_ROLE), e.getMessage());
    }

    public static void throwEquivalentCheckedException(InvalidUserException e) throws com.atlassian.crowd.exception.InvalidUserException {
        throw new com.atlassian.crowd.exception.InvalidUserException((com.atlassian.crowd.embedded.api.User)SoapExceptionTranslator.toModelUser(e.getEntity()), e.getCause());
    }

    public static void throwEquivalentCheckedException(ObjectNotFoundException e) throws com.atlassian.crowd.exception.ObjectNotFoundException {
        String msg = e.getMessage();
        if (msg.startsWith(UserNotFoundException.class.getName())) {
            throw new UserNotFoundException(SoapExceptionTranslator.extractEntityName(msg), e.getCause());
        }
        if (msg.startsWith(GroupNotFoundException.class.getName())) {
            throw new GroupNotFoundException(SoapExceptionTranslator.extractEntityName(msg), e.getCause());
        }
        if (msg.startsWith(MembershipNotFoundException.class.getName())) {
            List<String> entityNames = SoapExceptionTranslator.extractEntityNames(msg);
            if (entityNames.size() >= 2) {
                String childName = entityNames.get(0);
                String parentName = entityNames.get(1);
                throw new MembershipNotFoundException(childName, parentName, e.getCause());
            }
            throw new MembershipNotFoundException("", "", e.getCause());
        }
        throw new com.atlassian.crowd.exception.ObjectNotFoundException(e.getMessage(), e.getCause());
    }

    public static void throwEquivalentUserNotFoundException(ObjectNotFoundException e) throws UserNotFoundException {
        try {
            SoapExceptionTranslator.throwEquivalentCheckedException(e);
        }
        catch (UserNotFoundException ex) {
            throw ex;
        }
        catch (com.atlassian.crowd.exception.ObjectNotFoundException ex) {
            throw new AssertionError((Object)("Should not throw " + ex.getClass().getCanonicalName()));
        }
    }

    public static void throwEquivalentGroupNotFoundException(ObjectNotFoundException e) throws GroupNotFoundException {
        try {
            SoapExceptionTranslator.throwEquivalentCheckedException(e);
        }
        catch (GroupNotFoundException ex) {
            throw ex;
        }
        catch (com.atlassian.crowd.exception.ObjectNotFoundException ex) {
            throw new AssertionError((Object)("Should not throw " + ex.getClass().getCanonicalName()));
        }
    }

    public static void throwEquivalentMembershipNotFoundException(ObjectNotFoundException e) throws MembershipNotFoundException {
        try {
            SoapExceptionTranslator.throwEquivalentCheckedException(e);
        }
        catch (MembershipNotFoundException ex) {
            throw ex;
        }
        catch (com.atlassian.crowd.exception.ObjectNotFoundException ex) {
            throw new AssertionError((Object)("Should not throw " + ex.getClass().getCanonicalName()));
        }
    }

    public static void throwEquivalentObjectNotFoundException(ObjectNotFoundException e) throws com.atlassian.crowd.exception.ObjectNotFoundException {
        try {
            SoapExceptionTranslator.throwEquivalentCheckedException(e);
        }
        catch (UserNotFoundException e1) {
            throw new AssertionError((Object)("Should not throw " + e1.getClass().getCanonicalName()));
        }
        catch (GroupNotFoundException e1) {
            throw new AssertionError((Object)("Should not throw " + e1.getClass().getCanonicalName()));
        }
        catch (MembershipNotFoundException e1) {
            throw new AssertionError((Object)("Should not throw " + e1.getClass().getCanonicalName()));
        }
    }

    public static void throwEquivalentUserOrGroupNotFoundException(ObjectNotFoundException e) throws UserNotFoundException, GroupNotFoundException {
        try {
            SoapExceptionTranslator.throwEquivalentCheckedException(e);
        }
        catch (UserNotFoundException ex) {
            throw ex;
        }
        catch (GroupNotFoundException ex) {
            throw ex;
        }
        catch (com.atlassian.crowd.exception.ObjectNotFoundException ex) {
            throw new AssertionError((Object)("Should not throw " + ex.getClass().getCanonicalName()));
        }
    }

    public static void throwEquivalentUserOrGroupOrMembershipNotFoundException(ObjectNotFoundException e) throws UserNotFoundException, GroupNotFoundException, MembershipNotFoundException {
        try {
            SoapExceptionTranslator.throwEquivalentCheckedException(e);
        }
        catch (UserNotFoundException ex) {
            throw ex;
        }
        catch (GroupNotFoundException ex) {
            throw ex;
        }
        catch (MembershipNotFoundException ex) {
            throw ex;
        }
        catch (com.atlassian.crowd.exception.ObjectNotFoundException ex) {
            throw new AssertionError((Object)("Should not throw " + ex.getClass().getCanonicalName()));
        }
    }

    private static String extractEntityName(String line) {
        List<String> entityNames = SoapExceptionTranslator.extractEntityNames(line);
        if (entityNames.isEmpty()) {
            return "";
        }
        return entityNames.get(0);
    }

    private static List<String> extractEntityNames(String line) {
        ArrayList<String> entityNames = new ArrayList<String>();
        Pattern p = Pattern.compile("<([^\"]*?)>");
        Matcher m = p.matcher(line);
        while (m.find()) {
            entityNames.add(m.group(1));
        }
        return entityNames;
    }

    private static DirectoryEntity toDirectoryEntity(final com.atlassian.crowd.embedded.api.User user) {
        return new DirectoryEntity(){

            @Override
            public Long getDirectoryId() {
                return user.getDirectoryId();
            }

            @Override
            public String getName() {
                return user.getName();
            }
        };
    }

    private static DirectoryEntity toDirectoryEntity(final Group group) {
        return new DirectoryEntity(){

            @Override
            public Long getDirectoryId() {
                return group.getDirectoryId();
            }

            @Override
            public String getName() {
                return group.getName();
            }
        };
    }

    private static com.atlassian.crowd.model.user.User toModelUser(final DirectoryEntity entity) {
        return new com.atlassian.crowd.model.user.User(){

            @Override
            public String getFirstName() {
                return null;
            }

            @Override
            public String getLastName() {
                return null;
            }

            @Override
            public long getDirectoryId() {
                return entity.getDirectoryId();
            }

            @Override
            public boolean isActive() {
                return false;
            }

            @Override
            public String getEmailAddress() {
                return null;
            }

            @Override
            public String getDisplayName() {
                return entity.getName();
            }

            @Override
            public int compareTo(com.atlassian.crowd.embedded.api.User user) {
                return UserComparator.compareTo(this, user);
            }

            @Override
            public String getName() {
                return entity.getName();
            }
        };
    }

    private static User toSoapIntegrationUser(final String username) {
        return new User(){

            @Override
            public String getFirstName() {
                return null;
            }

            @Override
            public String getLastName() {
                return null;
            }

            @Override
            public Long getDirectoryId() {
                return -1L;
            }

            @Override
            public boolean isActive() {
                return false;
            }

            @Override
            public String getEmailAddress() {
                return null;
            }

            @Override
            public String getDisplayName() {
                return username;
            }

            @Override
            public String getName() {
                return username;
            }

            @Override
            public String getIconLocation() {
                return "";
            }
        };
    }

    private static Group toModelGroup(final DirectoryEntity entity, final GroupType type) {
        return new Group(){

            @Override
            public GroupType getType() {
                return type;
            }

            @Override
            public boolean isActive() {
                return false;
            }

            @Override
            public String getDescription() {
                return null;
            }

            @Override
            public int compareTo(Group o) {
                return GroupComparator.compareTo(this, o);
            }

            @Override
            public long getDirectoryId() {
                return entity.getDirectoryId();
            }

            @Override
            public String getName() {
                return entity.getName();
            }
        };
    }
}

