/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.springsecurity;

import com.atlassian.crowd.exception.InvalidTokenException;
import com.atlassian.crowd.integration.http.HttpAuthenticator;
import com.atlassian.crowd.integration.springsecurity.CrowdSSOAuthenticationDetails;
import com.atlassian.crowd.integration.springsecurity.CrowdSSOAuthenticationToken;
import com.atlassian.crowd.integration.springsecurity.RequestToApplicationMapper;
import com.atlassian.crowd.model.authentication.ValidationFactor;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.LoginUrlAuthenticationEntryPoint;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;
import org.springframework.security.web.savedrequest.DefaultSavedRequest;
import org.springframework.security.web.savedrequest.HttpSessionRequestCache;

public class CrowdSSOAuthenticationProcessingFilter
extends UsernamePasswordAuthenticationFilter {
    private HttpAuthenticator httpAuthenticator;
    private RequestToApplicationMapper requestToApplicationMapper;
    private LoginUrlAuthenticationEntryPoint authenticationProcessingFilterEntryPoint;

    @Override
    protected boolean requiresAuthentication(HttpServletRequest request, HttpServletResponse response) {
        boolean usernamePasswordAuthentication = super.requiresAuthentication(request, response);
        if (!usernamePasswordAuthentication) {
            Authentication authenticatedToken = null;
            try {
                CrowdSSOAuthenticationToken crowdAuthRequest = new CrowdSSOAuthenticationToken(this.httpAuthenticator.getToken(request));
                this.doSetDetails(request, crowdAuthRequest);
                authenticatedToken = this.getAuthenticationManager().authenticate((Authentication)crowdAuthRequest);
            }
            catch (InvalidTokenException e) {
            }
            catch (AuthenticationException e) {
                // empty catch block
            }
            if (authenticatedToken == null) {
                SecurityContextHolder.clearContext();
            } else {
                SecurityContextHolder.getContext().setAuthentication(authenticatedToken);
                this.storeTokenIfCrowd(request, response, authenticatedToken);
            }
        }
        return usernamePasswordAuthentication;
    }

    @Override
    protected void setDetails(HttpServletRequest request, UsernamePasswordAuthenticationToken authRequest) {
        this.doSetDetails(request, (AbstractAuthenticationToken)authRequest);
    }

    static String requestUriWithoutContext(HttpServletRequest request) {
        return request.getRequestURI().substring(request.getContextPath().length());
    }

    boolean canUseSavedRequestToAuthenticate(HttpServletRequest request) {
        if (super.requiresAuthentication(request, null)) {
            return true;
        }
        if (this.authenticationProcessingFilterEntryPoint != null) {
            String loginFormUrl = this.authenticationProcessingFilterEntryPoint.getLoginFormUrl();
            return CrowdSSOAuthenticationProcessingFilter.requestUriWithoutContext(request).equals(loginFormUrl);
        }
        return false;
    }

    protected void doSetDetails(HttpServletRequest request, AbstractAuthenticationToken authRequest) {
        String application;
        if (this.requestToApplicationMapper != null) {
            DefaultSavedRequest savedRequest = (DefaultSavedRequest)new HttpSessionRequestCache().getRequest(request, null);
            String path = this.canUseSavedRequestToAuthenticate(request) && savedRequest != null ? savedRequest.getRequestURI().substring(savedRequest.getContextPath().length()) : CrowdSSOAuthenticationProcessingFilter.requestUriWithoutContext(request);
            application = this.requestToApplicationMapper.getApplication(path);
        } else {
            application = this.httpAuthenticator.getSoapClientProperties().getApplicationName();
        }
        ValidationFactor[] validationFactors = this.httpAuthenticator.getValidationFactors(request);
        authRequest.setDetails((Object)new CrowdSSOAuthenticationDetails(application, validationFactors));
    }

    private void storeTokenIfCrowd(HttpServletRequest request, HttpServletResponse response, Authentication authResult) {
        if (authResult instanceof CrowdSSOAuthenticationToken && authResult.getCredentials() != null) {
            try {
                this.httpAuthenticator.setPrincipalToken(request, response, authResult.getCredentials().toString());
            }
            catch (Exception e) {
                this.logger.error((Object)"Unable to set Crowd SSO token", (Throwable)e);
            }
        }
    }

    @Override
    protected void successfulAuthentication(HttpServletRequest request, HttpServletResponse response, Authentication authResult) throws IOException, ServletException {
        this.storeTokenIfCrowd(request, response, authResult);
        super.successfulAuthentication(request, response, authResult);
    }

    @Override
    protected void unsuccessfulAuthentication(HttpServletRequest request, HttpServletResponse response, AuthenticationException failed) throws IOException, ServletException {
        try {
            this.httpAuthenticator.logoff(request, response);
        }
        catch (Exception e) {
            this.logger.error((Object)"Unable to unset Crowd SSO token", (Throwable)e);
        }
        super.unsuccessfulAuthentication(request, response, failed);
    }

    public void setHttpAuthenticator(HttpAuthenticator httpAuthenticator) {
        this.httpAuthenticator = httpAuthenticator;
    }

    public void setRequestToApplicationMapper(RequestToApplicationMapper requestToApplicationMapper) {
        this.requestToApplicationMapper = requestToApplicationMapper;
    }

    public void setLoginUrlAuthenticationEntryPoint(LoginUrlAuthenticationEntryPoint filterEntryPoint) {
        this.authenticationProcessingFilterEntryPoint = filterEntryPoint;
    }
}

