/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.rest.service.factory;

import com.atlassian.crowd.integration.rest.service.RestCrowdClient;
import com.atlassian.crowd.service.client.ClientProperties;
import com.atlassian.crowd.service.client.ClientPropertiesImpl;
import com.atlassian.crowd.service.client.CrowdClient;
import com.atlassian.crowd.service.factory.CrowdClientFactory;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;

public class RestCrowdClientFactory
implements CrowdClientFactory {
    @Override
    public CrowdClient newInstance(String url, String applicationName, String applicationPassword) {
        RestClientProperties clientProperties = new RestClientProperties(url, applicationName, applicationPassword);
        return this.newInstance(clientProperties);
    }

    @Override
    public CrowdClient newInstance(ClientProperties clientProperties) {
        return new RestCrowdClient(clientProperties);
    }

    private static class RestClientProperties
    extends ClientPropertiesImpl {
        private final String baseURL;
        private final String applicationName;
        private final String applicationPassword;

        RestClientProperties(String url, String applicationName, String applicationPassword) {
            this.baseURL = StringUtils.removeEnd((String)url, (String)"/");
            this.applicationName = applicationName;
            this.applicationPassword = applicationPassword;
            this.updateProperties(new Properties());
        }

        @Override
        public String getBaseURL() {
            return this.baseURL;
        }

        @Override
        public String getApplicationName() {
            return this.applicationName;
        }

        @Override
        public String getApplicationPassword() {
            return this.applicationPassword;
        }
    }
}

