/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.osuser;

import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.exception.ApplicationAccessDeniedException;
import com.atlassian.crowd.exception.ApplicationPermissionException;
import com.atlassian.crowd.exception.ExpiredCredentialException;
import com.atlassian.crowd.exception.InactiveAccountException;
import com.atlassian.crowd.exception.InvalidAuthenticationException;
import com.atlassian.crowd.exception.InvalidAuthorizationTokenException;
import com.atlassian.crowd.exception.InvalidCredentialException;
import com.atlassian.crowd.exception.InvalidUserException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.integration.soap.SOAPPrincipal;
import com.atlassian.crowd.model.authentication.UserAuthenticationContext;
import com.atlassian.crowd.service.AuthenticationManager;
import com.atlassian.crowd.service.UserManager;
import com.atlassian.crowd.service.cache.CacheExpiryManager;
import com.atlassian.crowd.service.cache.CachingManagerFactory;
import com.atlassian.crowd.util.Assert;
import com.opensymphony.user.Entity;
import com.opensymphony.user.provider.CredentialsProvider;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.Logger;

public class CrowdCredentialsProvider
implements CredentialsProvider {
    protected final Logger logger = Logger.getLogger(this.getClass());
    private final UserManager userManager;
    private final AuthenticationManager authenticationManager;
    private final CacheExpiryManager cacheExpiryManager;

    public CrowdCredentialsProvider() {
        this(CachingManagerFactory.getUserManagerInstance(), CachingManagerFactory.getCacheAwareAuthenticationManagerInstance(), CachingManagerFactory.getCacheExpiryManagerInstance());
    }

    public CrowdCredentialsProvider(UserManager userManager, AuthenticationManager authenticationManager, CacheExpiryManager cacheExpiryManager) {
        this.userManager = userManager;
        this.authenticationManager = authenticationManager;
        this.cacheExpiryManager = cacheExpiryManager;
    }

    public boolean authenticate(String name, String password) {
        Assert.notNull(name);
        try {
            UserAuthenticationContext authenticationContext = new UserAuthenticationContext();
            authenticationContext.setCredential(new PasswordCredential(password));
            authenticationContext.setName(name);
            this.authenticationManager.authenticate(authenticationContext);
            return true;
        }
        catch (InvalidAuthenticationException e) {
            this.logger.info((Object)("Could not authenticate " + name + ". The username or password were incorrect."));
        }
        catch (InactiveAccountException e) {
            this.logger.info((Object)("Could not authenticate " + name + ". The account is inactive and the user is not allowed to login."));
        }
        catch (InvalidAuthorizationTokenException e) {
            throw new RuntimeException(e);
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
        catch (ApplicationAccessDeniedException e) {
            this.logger.info((Object)("Could not authenticate " + name + ". The user does not have access to authenticate with the Crowd application."));
        }
        catch (ExpiredCredentialException e) {
            this.logger.info((Object)("Could not authenticate " + name + ". The account has an expired password."));
        }
        return false;
    }

    public boolean changePassword(String name, String password) {
        Assert.notNull(name);
        try {
            PasswordCredential credential = new PasswordCredential(password);
            this.userManager.updatePassword(name, credential);
            return true;
        }
        catch (ApplicationPermissionException e) {
            String message = "This application does not have the rights to change the password for " + name;
            this.logger.info((Object)message, (Throwable)e);
            throw new IllegalArgumentException(message);
        }
        catch (InvalidCredentialException e) {
            String message = "Could not change the password for " + name + ". Reason: " + e.getMessage();
            this.logger.info((Object)message, (Throwable)e);
            throw new IllegalArgumentException(message, e);
        }
        catch (UserNotFoundException e) {
            this.logger.warn((Object)("Could not update the password for " + name + ". The user could not be found."));
        }
        catch (InvalidAuthorizationTokenException e) {
            throw new RuntimeException(e);
        }
        catch (InvalidAuthenticationException e) {
            throw new RuntimeException(e);
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
        return false;
    }

    public boolean create(String username) {
        try {
            SOAPPrincipal user = new SOAPPrincipal();
            user.setActive(true);
            user.setName(username);
            this.userManager.addUser(user, null);
            return true;
        }
        catch (ApplicationPermissionException e) {
            this.logger.info((Object)("This application does not have the rights to create the user " + username));
        }
        catch (InvalidCredentialException e) {
            this.logger.info((Object)("Could not create the user " + username + ". The password was invalid. Did it meet the directory complexity requirements?"));
        }
        catch (InvalidUserException e) {
            this.logger.warn((Object)("Could not create the user " + username + ". The supplied user was invalid."));
        }
        catch (InvalidAuthorizationTokenException e) {
            throw new RuntimeException(e);
        }
        catch (InvalidAuthenticationException e) {
            throw new RuntimeException(e);
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
        return false;
    }

    public void flushCaches() {
        this.cacheExpiryManager.flush();
    }

    public boolean handles(String username) {
        if (username == null) {
            return false;
        }
        try {
            return this.userManager.isUser(username);
        }
        catch (InvalidAuthorizationTokenException e) {
            throw new RuntimeException(e);
        }
        catch (InvalidAuthenticationException e) {
            throw new RuntimeException(e);
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean init(Properties properties) {
        return true;
    }

    public List list() {
        try {
            return this.userManager.getAllUserNames();
        }
        catch (InvalidAuthorizationTokenException e) {
            throw new RuntimeException(e);
        }
        catch (InvalidAuthenticationException e) {
            throw new RuntimeException(e);
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean load(String name, Entity.Accessor accessor) {
        Assert.notNull(name);
        try {
            SOAPPrincipal user = this.userManager.getUser(name);
            if (user != null) {
                accessor.setName(user.getName());
                accessor.setMutable(true);
                return true;
            }
        }
        catch (UserNotFoundException e) {
            this.logger.info((Object)("Could not find the user " + name));
        }
        catch (InvalidAuthorizationTokenException e) {
            throw new RuntimeException(e);
        }
        catch (InvalidAuthenticationException e) {
            throw new RuntimeException(e);
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
        return false;
    }

    public boolean remove(String username) {
        Assert.notNull(username);
        try {
            this.userManager.removeUser(username);
            return true;
        }
        catch (ApplicationPermissionException e) {
            this.logger.info((Object)("This application does not have the rights to remove the user " + username));
        }
        catch (UserNotFoundException e) {
            this.logger.warn((Object)("Could not remove the user " + username + " because the user could not be found"));
        }
        catch (InvalidAuthorizationTokenException e) {
            throw new RuntimeException(e);
        }
        catch (InvalidAuthenticationException e) {
            throw new RuntimeException(e);
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
        return false;
    }

    public boolean store(String string, Entity.Accessor accessor) {
        return true;
    }

    public void fetchInCache(String username) throws UserNotFoundException, InvalidAuthenticationException, OperationFailedException {
        try {
            this.userManager.getUser(username);
        }
        catch (RemoteException e) {
            throw new OperationFailedException(e);
        }
        catch (InvalidAuthorizationTokenException e) {
            throw new InvalidAuthenticationException(username, e);
        }
    }
}

