/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.springsecurity;

import com.atlassian.crowd.integration.springsecurity.DynamicProviderManager;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.springframework.security.Authentication;
import org.springframework.security.AuthenticationException;
import org.springframework.security.providers.AuthenticationProvider;
import org.springframework.security.providers.ProviderManager;

public class DynamicProviderManagerImpl
extends ProviderManager
implements DynamicProviderManager {
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Authentication doAuthentication(Authentication authentication) throws AuthenticationException {
        this.readWriteLock.readLock().lock();
        try {
            Authentication authentication2 = super.doAuthentication(authentication);
            return authentication2;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProvider(AuthenticationProvider provider) {
        this.readWriteLock.writeLock().lock();
        try {
            this.getProviders().add(provider);
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeProvider(AuthenticationProvider provider) {
        this.readWriteLock.writeLock().lock();
        try {
            boolean bl = this.getProviders().remove(provider);
            return bl;
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }
}

