/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.osuser;

import com.atlassian.crowd.exception.ApplicationPermissionException;
import com.atlassian.crowd.exception.GroupNotFoundException;
import com.atlassian.crowd.exception.InvalidAuthenticationException;
import com.atlassian.crowd.exception.InvalidAuthorizationTokenException;
import com.atlassian.crowd.exception.InvalidGroupException;
import com.atlassian.crowd.exception.MembershipNotFoundException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.integration.soap.SOAPGroup;
import com.atlassian.crowd.service.GroupManager;
import com.atlassian.crowd.service.GroupMembershipManager;
import com.atlassian.crowd.service.UserManager;
import com.atlassian.crowd.service.cache.CacheExpiryManager;
import com.atlassian.crowd.service.cache.CachingManagerFactory;
import com.atlassian.crowd.util.Assert;
import com.opensymphony.user.Entity;
import com.opensymphony.user.provider.AccessProvider;
import java.rmi.RemoteException;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.Logger;

public class CrowdAccessProvider
implements AccessProvider {
    protected final Logger logger = Logger.getLogger(this.getClass());
    private final UserManager userManager;
    private final GroupManager groupManager;
    private final GroupMembershipManager membershipManager;
    private final CacheExpiryManager cacheExpiryManager;

    public CrowdAccessProvider() {
        this(CachingManagerFactory.getUserManagerInstance(), CachingManagerFactory.getGroupManagerInstance(), CachingManagerFactory.getGroupMembershipManagerInstance(), CachingManagerFactory.getCacheExpiryManagerInstance());
    }

    public CrowdAccessProvider(UserManager userManager, GroupManager groupManager, GroupMembershipManager membershipManager, CacheExpiryManager cacheExpiryManager) {
        this.userManager = userManager;
        this.groupManager = groupManager;
        this.membershipManager = membershipManager;
        this.cacheExpiryManager = cacheExpiryManager;
    }

    public boolean handles(String name) {
        Assert.notNull(name);
        try {
            if (this.userManager.isUser(name) || this.groupManager.isGroup(name)) {
                return true;
            }
        }
        catch (InvalidAuthorizationTokenException e) {
            throw new RuntimeException(e);
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
        catch (InvalidAuthenticationException e) {
            throw new RuntimeException(e);
        }
        return false;
    }

    public boolean init(Properties properties) {
        return true;
    }

    public List list() {
        List groupNames = null;
        try {
            groupNames = this.groupManager.getAllGroupNames();
        }
        catch (InvalidAuthorizationTokenException e) {
            throw new RuntimeException(e);
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
        catch (InvalidAuthenticationException e) {
            throw new RuntimeException(e);
        }
        return groupNames;
    }

    public boolean load(String string, Entity.Accessor accessor) {
        accessor.setMutable(true);
        return true;
    }

    public boolean addToGroup(String username, String groupname) {
        try {
            this.membershipManager.addMembership(username, groupname);
            return true;
        }
        catch (ApplicationPermissionException e) {
            this.logger.info((Object)("This application does not have the rights to add " + username + " to " + groupname));
        }
        catch (UserNotFoundException e) {
            this.logger.info((Object)("User (" + username + ") not found: " + e.getMessage()));
        }
        catch (GroupNotFoundException e) {
            this.logger.info((Object)("Group (" + groupname + ") not found: " + e.getMessage()));
        }
        catch (InvalidAuthorizationTokenException e) {
            throw new RuntimeException(e);
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
        catch (InvalidAuthenticationException e) {
            throw new RuntimeException(e);
        }
        return false;
    }

    public boolean inGroup(String username, String groupname) {
        try {
            return this.membershipManager.isMember(username, groupname);
        }
        catch (InvalidAuthorizationTokenException e) {
            throw new RuntimeException(e);
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
        catch (InvalidAuthenticationException e) {
            throw new RuntimeException(e);
        }
    }

    public List listGroupsContainingUser(String username) {
        List groupNames = null;
        try {
            groupNames = this.membershipManager.getMemberships(username);
        }
        catch (UserNotFoundException e) {
            this.logger.info((Object)("User " + username + " not found: " + e.getMessage()));
        }
        catch (InvalidAuthorizationTokenException e) {
            throw new RuntimeException(e);
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
        catch (InvalidAuthenticationException e) {
            throw new RuntimeException(e);
        }
        if (groupNames == null) {
            groupNames = Collections.EMPTY_LIST;
        }
        return groupNames;
    }

    public List listUsersInGroup(String name) {
        List userNames = null;
        try {
            userNames = this.membershipManager.getMembers(name);
        }
        catch (GroupNotFoundException e) {
            this.logger.info((Object)("Group " + name + " not found: " + e.getMessage()));
        }
        catch (InvalidAuthorizationTokenException e) {
            throw new RuntimeException(e);
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
        catch (InvalidAuthenticationException e) {
            throw new RuntimeException(e);
        }
        if (userNames == null) {
            userNames = Collections.EMPTY_LIST;
        }
        return userNames;
    }

    public boolean removeFromGroup(String username, String groupname) {
        try {
            this.membershipManager.removeMembership(username, groupname);
            return true;
        }
        catch (ApplicationPermissionException e) {
            this.logger.info((Object)("This application does not have the rights to remove " + username + " from " + groupname));
        }
        catch (UserNotFoundException e) {
            this.logger.info((Object)("Could not remove " + username + " from group " + groupname + ":" + e.getMessage()));
        }
        catch (GroupNotFoundException e) {
            this.logger.info((Object)("Could not remove " + username + " from group " + groupname + ":" + e.getMessage()));
        }
        catch (InvalidAuthorizationTokenException e) {
            throw new RuntimeException(e);
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
        catch (MembershipNotFoundException e) {
            this.logger.info((Object)("Could not remove " + username + " from group " + groupname + ":" + e.getMessage()));
        }
        catch (InvalidAuthenticationException e) {
            throw new RuntimeException(e);
        }
        return false;
    }

    public boolean remove(String name) {
        try {
            this.groupManager.removeGroup(name);
            return true;
        }
        catch (ApplicationPermissionException e) {
            this.logger.info((Object)("This application does not have the rights to remove the group " + name));
        }
        catch (GroupNotFoundException e) {
            this.logger.info((Object)("Could not find the group " + name + " to remove: " + e.getMessage()));
        }
        catch (InvalidAuthorizationTokenException e) {
            throw new RuntimeException(e);
        }
        catch (InvalidAuthenticationException e) {
            throw new RuntimeException(e);
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
        return false;
    }

    public boolean store(String name, Entity.Accessor accessor) {
        return false;
    }

    public boolean create(String name) {
        Assert.notNull(name);
        try {
            SOAPGroup group = new SOAPGroup();
            group.setActive(true);
            group.setName(name);
            this.groupManager.addGroup(group);
            return true;
        }
        catch (ApplicationPermissionException e) {
            this.logger.info((Object)("This application does not have the rights to add the group " + name));
        }
        catch (InvalidGroupException e) {
            this.logger.warn((Object)("An attempt was made to create an invalid group: " + e.getMessage()));
        }
        catch (InvalidAuthorizationTokenException e) {
            throw new RuntimeException(e);
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
        catch (InvalidAuthenticationException e) {
            throw new RuntimeException(e);
        }
        return false;
    }

    public void flushCaches() {
        this.cacheExpiryManager.flush();
    }
}

