/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.seraph.v22;

import com.atlassian.crowd.integration.exception.InvalidTokenException;
import com.atlassian.crowd.integration.http.HttpAuthenticator;
import com.atlassian.crowd.integration.service.UserManager;
import com.atlassian.crowd.integration.soap.SOAPPrincipal;
import com.atlassian.seraph.auth.AuthenticatorException;
import com.atlassian.seraph.auth.DefaultAuthenticator;
import com.atlassian.seraph.auth.LoginReason;
import com.atlassian.seraph.elevatedsecurity.ElevatedSecurityGuard;
import com.atlassian.seraph.util.RedirectUtils;
import java.security.Principal;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public abstract class CrowdAuthenticator
extends DefaultAuthenticator {
    private static final Logger logger = Logger.getLogger(CrowdAuthenticator.class);
    private static final String CORRECT_PASSWORD = "c";
    private static final String INCORRECT_PASSWORD = "i";
    protected final HttpAuthenticator httpAuthenticator;
    protected final UserManager userManager;

    public CrowdAuthenticator(HttpAuthenticator httpAuthenticator, UserManager userManager) {
        this.httpAuthenticator = httpAuthenticator;
        this.userManager = userManager;
    }

    protected boolean authenticate(Principal user, String password) {
        return CORRECT_PASSWORD.equals(password);
    }

    public boolean login(HttpServletRequest request, HttpServletResponse response, String username, String password, boolean cookie) throws AuthenticatorException {
        boolean authenticated;
        try {
            this.logout(request, response);
            request.setAttribute(LoginReason.REQUEST_ATTR_NAME, null);
            logger.debug((Object)"Authenticating user with Crowd");
            this.httpAuthenticator.authenticate(request, response, username, password);
            authenticated = true;
        }
        catch (Exception e) {
            logger.info((Object)e.getMessage(), (Throwable)e);
            authenticated = false;
        }
        String fakePassword = authenticated ? CORRECT_PASSWORD : INCORRECT_PASSWORD;
        logger.debug((Object)"Updating user session for Seraph");
        authenticated = super.login(request, response, username, fakePassword, cookie);
        return authenticated;
    }

    public boolean logout(HttpServletRequest request, HttpServletResponse response) throws AuthenticatorException {
        try {
            logger.debug((Object)"Logging off from Crowd");
            this.httpAuthenticator.logoff(request, response);
            logger.debug((Object)"Invalidating user in Crowd-Seraph specific session variables");
            this.logoutUser(request);
        }
        catch (Exception e) {
            logger.info((Object)e.getMessage(), (Throwable)e);
        }
        logger.debug((Object)"Invalidating user in Seraph specific session variables");
        return super.logout(request, response);
    }

    protected boolean isAuthenticated(HttpServletRequest request, HttpServletResponse response) {
        Principal basicAuthUser;
        boolean authenticated = this.isTrustedAppsRequest(request);
        if (!authenticated) {
            try {
                authenticated = this.httpAuthenticator.isAuthenticated(request, response);
                if (authenticated && logger.isDebugEnabled()) {
                    logger.debug((Object)"User IS authenticated via the Crowd session-token");
                } else if (logger.isDebugEnabled()) {
                    logger.debug((Object)"User is NOT authenticated via the Crowd session-token");
                }
            }
            catch (Exception e) {
                logger.info((Object)"Error while attempting to check if user isAuthenticated with Crowd", (Throwable)e);
            }
        }
        if (!authenticated) {
            authenticated = this.rememberMeLoginToCrowd(request, response);
            if (authenticated && logger.isDebugEnabled()) {
                logger.debug((Object)"Authenticated via remember-me cookie");
            } else if (logger.isDebugEnabled()) {
                logger.debug((Object)"Failed to authenticate via remember-me cookie");
            }
        }
        if (!authenticated && RedirectUtils.isBasicAuthentication((HttpServletRequest)request, (String)this.getAuthType()) && (basicAuthUser = this.getUserFromBasicAuthentication(request, response)) != null) {
            authenticated = true;
        }
        if (!authenticated) {
            logger.debug((Object)"Request is not authenticated, logging out the user");
            try {
                this.logoutUser(request);
                if (response != null) {
                    super.logout(request, response);
                }
            }
            catch (AuthenticatorException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            authenticated = false;
        }
        return authenticated;
    }

    protected boolean rememberMeLoginToCrowd(HttpServletRequest request, HttpServletResponse response) {
        Principal cookieUser = this.getUserFromCookie(request, response);
        if (cookieUser == null) {
            return false;
        }
        logger.debug((Object)"User successfully authenticated via remember-me cookie verification");
        try {
            this.httpAuthenticator.authenticateWithoutValidatingPassword(request, response, cookieUser.getName());
            return true;
        }
        catch (Exception e) {
            logger.debug((Object)("Could not register remember-me cookie authenticated user with Crowd SSO: " + cookieUser.getName() + ", reason: " + e.getMessage()), (Throwable)e);
            this.removePrincipalFromSessionContext(request);
            return false;
        }
    }

    abstract void logoutUser(HttpServletRequest var1);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Principal getUser(HttpServletRequest request, HttpServletResponse response) {
        String cookieToken;
        ElevatedSecurityGuard securityGuard = this.getElevatedSecurityGuard();
        Principal user = null;
        if (this.isTrustedAppsRequest(request)) {
            return this.getUserFromSession(request);
        }
        if (!this.isAuthenticated(request, response)) return user;
        try {
            cookieToken = this.httpAuthenticator.getToken(request);
            String sessionToken = (String)request.getSession().getAttribute(this.httpAuthenticator.getClientProperties().getSessionTokenKey());
            if (cookieToken != null && cookieToken.equals(sessionToken)) {
                user = this.getUserFromSession(request);
            }
        }
        catch (InvalidTokenException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
        if (user == null) {
            try {
                SOAPPrincipal soapPrincipal = this.userManager.getUserFromToken(cookieToken);
                user = this.getUser(soapPrincipal.getName());
            }
            catch (Exception e) {
                logger.info((Object)e.getMessage(), (Throwable)e);
            }
            if (user == null) return user;
            if (!this.authoriseUserAndEstablishSession(request, response, user)) return null;
            LoginReason.OK.stampRequestResponse(request, response);
            securityGuard.onSuccessfulLoginAttempt(request, user.getName());
            request.getSession().setAttribute(this.httpAuthenticator.getClientProperties().getSessionTokenKey(), (Object)cookieToken);
            return user;
        }
        LoginReason.OK.stampRequestResponse(request, response);
        return user;
    }

    private boolean isTrustedAppsRequest(HttpServletRequest request) {
        if ("success".equals(request.getAttribute("os_authstatus"))) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"User IS authenticated via previous filter/trusted apps");
            }
            return true;
        }
        return false;
    }
}

