/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.http;

import com.atlassian.crowd.integration.authentication.PasswordCredential;
import com.atlassian.crowd.integration.authentication.PrincipalAuthenticationContext;
import com.atlassian.crowd.integration.authentication.ValidationFactor;
import com.atlassian.crowd.integration.exception.InactiveAccountException;
import com.atlassian.crowd.integration.exception.InvalidAuthenticationException;
import com.atlassian.crowd.integration.exception.InvalidAuthorizationTokenException;
import com.atlassian.crowd.integration.exception.InvalidTokenException;
import com.atlassian.crowd.integration.exception.ObjectNotFoundException;
import com.atlassian.crowd.integration.http.HttpAuthenticator;
import com.atlassian.crowd.integration.service.AuthenticationManager;
import com.atlassian.crowd.integration.service.cache.CachingManagerFactory;
import com.atlassian.crowd.integration.service.soap.client.ClientProperties;
import com.atlassian.crowd.integration.service.soap.client.SecurityServerClient;
import com.atlassian.crowd.integration.soap.SOAPPrincipal;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Date;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;

public class HttpAuthenticatorImpl
implements HttpAuthenticator {
    private static final Logger logger = Logger.getLogger(HttpAuthenticatorImpl.class);
    private final AuthenticationManager authenticationManager;

    public HttpAuthenticatorImpl(AuthenticationManager authenticationManager) {
        this.authenticationManager = authenticationManager;
    }

    public HttpAuthenticatorImpl() {
        this(CachingManagerFactory.getAuthenticationManagerInstance());
    }

    private void invalidateClient(HttpServletRequest request, HttpServletResponse response, String token) throws InvalidAuthorizationTokenException, RemoteException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Invalidating the Crowd token: " + token));
        }
        HttpSession session = request.getSession();
        session.removeAttribute(this.getClientProperties().getSessionTokenKey());
        request.removeAttribute(this.getCookieTokenKey());
        if (response != null) {
            Cookie tokenCookie = new Cookie(this.getCookieTokenKey(), token);
            tokenCookie.setPath("/");
            this.processClientCookieDomain(tokenCookie);
            tokenCookie.setMaxAge(0);
            response.addCookie(tokenCookie);
        }
    }

    public void setPrincipalToken(HttpServletRequest request, HttpServletResponse response, String token) throws InvalidAuthorizationTokenException, RemoteException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Setting the Crowd token: " + token));
        }
        HttpSession session = request.getSession();
        session.setAttribute(this.getClientProperties().getSessionLastValidation(), (Object)new Date());
        request.setAttribute(this.getCookieTokenKey(), (Object)token);
        if (response != null && request.getAttribute(REQUEST_SSO_COOKIE_COMMITTED) == null) {
            Cookie tokenCookie = new Cookie(this.getCookieTokenKey(), token);
            this.processClientCookieDomain(tokenCookie);
            tokenCookie.setPath("/");
            response.addCookie(tokenCookie);
            request.setAttribute(REQUEST_SSO_COOKIE_COMMITTED, (Object)Boolean.TRUE);
        }
    }

    public SOAPPrincipal getPrincipal(HttpServletRequest request) throws InvalidAuthorizationTokenException, RemoteException, ObjectNotFoundException, InvalidTokenException {
        return this.getSecurityServerClient().findPrincipalByToken(this.getToken(request));
    }

    public String getToken(HttpServletRequest request) throws InvalidTokenException {
        String token;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Checking for a SSO token that will need to be verified by Crowd.");
        }
        if ((token = (String)request.getAttribute(this.getCookieTokenKey())) == null) {
            Cookie[] cookies;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"No request header token could be found, now checking the browser submitted cookies.");
            }
            if ((cookies = request.getCookies()) != null && cookies.length > 0) {
                for (int i = 0; i < cookies.length; ++i) {
                    Cookie cookie = cookies[i];
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Cookie name/value: " + cookie.getName() + " / " + cookie.getValue()));
                    }
                    if (!this.getCookieTokenKey().equals(cookie.getName()) || cookie.getValue() == null) continue;
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Accepting the SSO cookie value: " + cookie.getValue()));
                    }
                    token = cookie.getValue();
                    break;
                }
            }
        }
        if (token == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Unable to find a valid Crowd token.");
            }
            throw new InvalidTokenException("Unable to find a valid principal token.");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Existing token value yet to be verified by Crowd: " + token));
        }
        return token;
    }

    public boolean isAuthenticated(HttpServletRequest request, HttpServletResponse response) throws InvalidAuthorizationTokenException, RemoteException {
        long timeSpread;
        String token;
        HttpSession session = request.getSession();
        try {
            token = this.getToken(request);
        }
        catch (InvalidTokenException e) {
            logger.debug((Object)"Non authenticated request, unable to find a valid Crowd token.");
            return false;
        }
        Date lastValidation = (Date)session.getAttribute(this.getClientProperties().getSessionLastValidation());
        if (lastValidation != null && this.getClientProperties().getSessionValidationInterval() > 0L && (timeSpread = lastValidation.getTime() + 60000L * this.getClientProperties().getSessionValidationInterval()) > System.currentTimeMillis()) {
            return true;
        }
        if (this.authenticationManager.isAuthenticated(token, this.getValidationFactors(request))) {
            this.setPrincipalToken(request, response, token);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void authenticate(HttpServletRequest request, HttpServletResponse response, String username, String password) throws InvalidAuthorizationTokenException, RemoteException, InvalidAuthenticationException, InactiveAccountException {
        block5: {
            String token;
            block4: {
                token = null;
                try {
                    PrincipalAuthenticationContext principalAuthenticationContext = this.getPrincipalAuthenticationContext(request, response, username, password);
                    token = this.authenticationManager.authenticate(principalAuthenticationContext);
                    if (token != null) break block4;
                }
                catch (Throwable throwable) {
                    if (token == null) {
                        this.invalidateClient(request, response, null);
                    } else {
                        this.setPrincipalToken(request, response, token);
                    }
                    throw throwable;
                }
                this.invalidateClient(request, response, null);
                break block5;
            }
            this.setPrincipalToken(request, response, token);
        }
    }

    public String verifyAuthentication(String username, String password, ValidationFactor[] validationFactors) throws InvalidAuthorizationTokenException, InvalidAuthenticationException, RemoteException, InactiveAccountException {
        PasswordCredential credential = new PasswordCredential(password);
        PrincipalAuthenticationContext principalAuthenticationContext = new PrincipalAuthenticationContext();
        principalAuthenticationContext.setApplication(this.getClientProperties().getApplicationName());
        principalAuthenticationContext.setCredential(credential);
        principalAuthenticationContext.setName(username);
        principalAuthenticationContext.setValidationFactors(validationFactors);
        return this.authenticationManager.authenticate(principalAuthenticationContext);
    }

    public void verifyAuthentication(String username, String password) throws InvalidAuthorizationTokenException, InvalidAuthenticationException, RemoteException, InactiveAccountException {
        this.authenticationManager.authenticate(username, password);
    }

    public ValidationFactor[] getValidationFactors(HttpServletRequest request) {
        ArrayList<ValidationFactor> validationFactors = new ArrayList<ValidationFactor>();
        if (request != null) {
            String agent;
            String remoteAddressXForwardFor;
            String remoteAddress = request.getRemoteAddr();
            if (remoteAddress != null && remoteAddress.length() > 0) {
                ValidationFactor validationFactor = new ValidationFactor();
                validationFactor.setName("remote_address");
                validationFactor.setValue(remoteAddress);
                validationFactors.add(validationFactor);
            }
            if ((remoteAddressXForwardFor = request.getHeader("X-Forwarded-For")) != null && !remoteAddressXForwardFor.equals(remoteAddress)) {
                ValidationFactor validationFactor = new ValidationFactor();
                validationFactor.setName("X-Forwarded-For");
                validationFactor.setValue(remoteAddressXForwardFor);
                validationFactors.add(validationFactor);
            }
            if ((agent = request.getHeader("User-Agent")) != null && agent.length() > 0) {
                ValidationFactor validationFactor = new ValidationFactor();
                validationFactor.setName("User-Agent");
                validationFactor.setValue(agent);
                validationFactors.add(validationFactor);
            }
        }
        return validationFactors.toArray(new ValidationFactor[validationFactors.size()]);
    }

    public void logoff(HttpServletRequest request, HttpServletResponse response) throws InvalidAuthorizationTokenException, RemoteException {
        String token = null;
        try {
            token = this.getToken(request);
            this.authenticationManager.invalidate(token);
        }
        catch (InvalidTokenException e) {
            // empty catch block
        }
        this.invalidateClient(request, response, token);
    }

    public PrincipalAuthenticationContext getPrincipalAuthenticationContext(HttpServletRequest request, HttpServletResponse response, String username, String password) {
        PasswordCredential credential = new PasswordCredential(password);
        PrincipalAuthenticationContext principalAuthenticationContext = new PrincipalAuthenticationContext();
        principalAuthenticationContext.setApplication(this.getClientProperties().getApplicationName());
        principalAuthenticationContext.setCredential(credential);
        principalAuthenticationContext.setName(username);
        principalAuthenticationContext.setValidationFactors(this.getValidationFactors(request));
        return principalAuthenticationContext;
    }

    private void processClientCookieDomain(Cookie tokenCookie) throws InvalidAuthorizationTokenException, RemoteException {
        String domain = this.getSecurityServerClient().getDomain();
        if (domain != null && domain.length() > 0 && !"localhost".equals(domain)) {
            tokenCookie.setDomain(domain);
        }
    }

    public ClientProperties getClientProperties() {
        return this.getSecurityServerClient().getClientProperties();
    }

    protected String getCookieTokenKey() {
        return this.getClientProperties().getCookieTokenKey();
    }

    public SecurityServerClient getSecurityServerClient() {
        return this.authenticationManager.getSecurityServerClient();
    }
}

