/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.acegi;

import com.atlassian.crowd.integration.acegi.CrowdSSOAuthenticationToken;
import com.atlassian.crowd.integration.exception.InvalidTokenException;
import com.atlassian.crowd.integration.http.HttpAuthenticator;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.acegisecurity.Authentication;
import org.acegisecurity.AuthenticationException;
import org.acegisecurity.context.SecurityContextHolder;
import org.acegisecurity.providers.UsernamePasswordAuthenticationToken;
import org.acegisecurity.ui.webapp.AuthenticationProcessingFilter;

public class CrowdSSOAuthenticationProcessingFilter
extends AuthenticationProcessingFilter {
    private HttpAuthenticator httpAuthenticator;

    protected boolean requiresAuthentication(HttpServletRequest request, HttpServletResponse response) {
        boolean usernamePasswordAuthentication = super.requiresAuthentication(request, response);
        if (!usernamePasswordAuthentication) {
            Authentication authenticatedToken = null;
            try {
                CrowdSSOAuthenticationToken crowdAuthRequest = new CrowdSSOAuthenticationToken(this.httpAuthenticator.getToken(request));
                crowdAuthRequest.setDetails(this.httpAuthenticator.getValidationFactors(request));
                authenticatedToken = this.getAuthenticationManager().authenticate((Authentication)crowdAuthRequest);
            }
            catch (InvalidTokenException e) {
            }
            catch (AuthenticationException e) {
                // empty catch block
            }
            if (authenticatedToken == null) {
                SecurityContextHolder.clearContext();
            } else {
                SecurityContextHolder.getContext().setAuthentication(authenticatedToken);
                try {
                    this.onSuccessfulAuthentication(request, response, authenticatedToken);
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
        }
        return usernamePasswordAuthentication;
    }

    protected void setDetails(HttpServletRequest request, UsernamePasswordAuthenticationToken authRequest) {
        authRequest.setDetails((Object)this.httpAuthenticator.getValidationFactors(request));
    }

    protected void onSuccessfulAuthentication(HttpServletRequest request, HttpServletResponse response, Authentication authResult) throws IOException {
        if (authResult instanceof CrowdSSOAuthenticationToken && authResult.getCredentials() != null) {
            try {
                this.httpAuthenticator.setPrincipalToken(request, response, authResult.getCredentials().toString());
            }
            catch (Exception e) {
                this.logger.error((Object)"Unable to set Crowd SSO token", (Throwable)e);
            }
        }
    }

    protected void onUnsuccessfulAuthentication(HttpServletRequest request, HttpServletResponse response, AuthenticationException failed) throws IOException {
        try {
            this.httpAuthenticator.logoff(request, response);
        }
        catch (Exception e) {
            this.logger.error((Object)"Unable to unset Crowd SSO token", (Throwable)e);
        }
    }

    public void setHttpAuthenticator(HttpAuthenticator httpAuthenticator) {
        this.httpAuthenticator = httpAuthenticator;
    }
}

