/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.acegi;

import com.atlassian.crowd.integration.acegi.CrowdSSOAuthenticationToken;
import com.atlassian.crowd.integration.acegi.CrowdSSOTokenInvalidException;
import com.atlassian.crowd.integration.acegi.user.CrowdUserDetails;
import com.atlassian.crowd.integration.acegi.user.CrowdUserDetailsService;
import com.atlassian.crowd.integration.authentication.ValidationFactor;
import com.atlassian.crowd.integration.exception.InactiveAccountException;
import com.atlassian.crowd.integration.exception.InvalidAuthenticationException;
import com.atlassian.crowd.integration.exception.InvalidTokenException;
import com.atlassian.crowd.integration.http.HttpAuthenticator;
import com.atlassian.crowd.integration.service.AuthenticationManager;
import org.acegisecurity.Authentication;
import org.acegisecurity.AuthenticationException;
import org.acegisecurity.AuthenticationServiceException;
import org.acegisecurity.BadCredentialsException;
import org.acegisecurity.DisabledException;
import org.acegisecurity.providers.AuthenticationProvider;
import org.acegisecurity.providers.UsernamePasswordAuthenticationToken;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class CrowdAuthenticationProvider
implements AuthenticationProvider,
InitializingBean {
    private static final Log logger = LogFactory.getLog(CrowdAuthenticationProvider.class);
    protected AuthenticationManager authenticationManager;
    protected HttpAuthenticator httpAuthenticator;
    protected CrowdUserDetailsService userDetailsService;

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        if (!this.supports(authentication.getClass())) {
            return null;
        }
        Authentication authenticatedToken = null;
        if (authentication instanceof UsernamePasswordAuthenticationToken) {
            logger.debug((Object)"Processing a UsernamePasswordAuthenticationToken");
            authenticatedToken = this.authenticateUsernamePassword((UsernamePasswordAuthenticationToken)authentication);
        } else if (authentication instanceof CrowdSSOAuthenticationToken) {
            logger.debug((Object)"Processing a CrowdSSOAuthenticationToken");
            authenticatedToken = this.authenticateCrowdSSO((CrowdSSOAuthenticationToken)authentication);
        }
        return authenticatedToken;
    }

    protected Authentication authenticateUsernamePassword(UsernamePasswordAuthenticationToken passwordToken) throws AuthenticationException {
        if (passwordToken.getPrincipal() == null || StringUtils.isEmpty((String)passwordToken.getPrincipal().toString())) {
            throw new BadCredentialsException("UsernamePasswordAuthenticationToken contains empty username");
        }
        if (passwordToken.getCredentials() == null || StringUtils.isEmpty((String)passwordToken.getCredentials().toString())) {
            throw new BadCredentialsException("UsernamePasswordAuthenticationToken contains empty password");
        }
        Object authenticatedToken = null;
        try {
            if (passwordToken.getDetails() != null && passwordToken.getDetails() instanceof ValidationFactor[]) {
                String crowdTokenString = this.httpAuthenticator.verifyAuthentication(passwordToken.getPrincipal().toString(), passwordToken.getCredentials().toString(), (ValidationFactor[])passwordToken.getDetails());
                CrowdUserDetails userDetails = this.userDetailsService.loadUserByUsername(passwordToken.getPrincipal().toString());
                authenticatedToken = new CrowdSSOAuthenticationToken(userDetails, crowdTokenString, userDetails.getAuthorities());
            } else {
                this.httpAuthenticator.verifyAuthentication(passwordToken.getPrincipal().toString(), passwordToken.getCredentials().toString());
                CrowdUserDetails userDetails = this.userDetailsService.loadUserByUsername(passwordToken.getPrincipal().toString());
                authenticatedToken = new UsernamePasswordAuthenticationToken((Object)userDetails, passwordToken.getCredentials(), userDetails.getAuthorities());
            }
        }
        catch (Exception e) {
            throw this.translateException(e);
        }
        return authenticatedToken;
    }

    protected Authentication authenticateCrowdSSO(CrowdSSOAuthenticationToken ssoToken) throws AuthenticationException {
        if (ssoToken.getCredentials() == null || StringUtils.isEmpty((String)ssoToken.getCredentials().toString())) {
            throw new BadCredentialsException("CrowdSSOAuthenticationToken contains empty token credential");
        }
        if (ssoToken.getDetails() == null || !(ssoToken.getDetails() instanceof ValidationFactor[])) {
            throw new BadCredentialsException("CrowdSSOAuthenticationToken does not contain any validation factors");
        }
        CrowdSSOAuthenticationToken authenticatedToken = null;
        String crowdTokenString = ssoToken.getCredentials().toString();
        try {
            if (!this.authenticationManager.isAuthenticated(crowdTokenString, (ValidationFactor[])ssoToken.getDetails())) {
                throw new CrowdSSOTokenInvalidException("Crowd SSO token is invalid");
            }
            CrowdUserDetails userDetails = this.userDetailsService.loadUserByToken(crowdTokenString);
            authenticatedToken = new CrowdSSOAuthenticationToken(userDetails, crowdTokenString, userDetails.getAuthorities());
        }
        catch (Exception e) {
            throw this.translateException(e);
        }
        return authenticatedToken;
    }

    protected AuthenticationException translateException(Exception e) {
        if (e instanceof AuthenticationException) {
            return (AuthenticationException)e;
        }
        if (e instanceof InvalidAuthenticationException || e instanceof InvalidTokenException) {
            return new BadCredentialsException(e.getMessage(), (Throwable)e);
        }
        if (e instanceof InactiveAccountException) {
            return new DisabledException(e.getMessage(), (Throwable)e);
        }
        return new AuthenticationServiceException(e.getMessage(), (Throwable)e);
    }

    public boolean supports(Class authentication) {
        return UsernamePasswordAuthenticationToken.class.isAssignableFrom(authentication) || CrowdSSOAuthenticationToken.class.isAssignableFrom(authentication);
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.authenticationManager, (String)"A Crowd authenticationManager must be set");
        Assert.notNull((Object)this.httpAuthenticator, (String)"An httpAuthenticator must be set");
        Assert.notNull((Object)this.userDetailsService, (String)"A userDetailsService must be set");
    }

    public void setAuthenticationManager(AuthenticationManager authenticationManager) {
        this.authenticationManager = authenticationManager;
    }

    public void setHttpAuthenticator(HttpAuthenticator httpAuthenticator) {
        this.httpAuthenticator = httpAuthenticator;
    }

    public void setUserDetailsService(CrowdUserDetailsService userDetailsService) {
        this.userDetailsService = userDetailsService;
    }
}

