/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.util;

import com.atlassian.core.util.ClassLoaderUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Properties;
import org.apache.log4j.Logger;

public class PropertyUtils
extends com.atlassian.core.util.PropertyUtils {
    private static final Logger logger = Logger.getLogger(PropertyUtils.class);
    private String propertyResourceName;
    private String propertyResourceLocation;

    public PropertyUtils() {
        this.propertyResourceName = "crowd.properties";
        this.init();
    }

    public PropertyUtils(String propertyResourceName) {
        this.propertyResourceName = propertyResourceName;
        this.init();
    }

    public PropertyUtils(String propertyResourceName, String propertyResourceLocation) {
        this.propertyResourceName = propertyResourceName;
        this.propertyResourceLocation = propertyResourceLocation;
    }

    public void init() {
        this.propertyResourceLocation = this.getResourceLocationFromFilesystem();
        if (this.propertyResourceLocation == null) {
            this.propertyResourceLocation = this.getResourceLocationFromClassPath(PropertyUtils.class);
        }
    }

    public Properties getProperties() {
        Properties properties = null;
        if (this.propertyResourceLocation != null) {
            try {
                URL url = new URL(this.propertyResourceLocation);
                properties = PropertyUtils.getPropertiesFromStream((InputStream)url.openStream());
            }
            catch (IOException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return properties;
    }

    public boolean removeProperty(String key) {
        boolean success = false;
        Properties properties = this.getProperties();
        Object currentValue = properties.remove(key);
        logger.info((Object)("Updating properties resource: " + this.propertyResourceName + " removing property with key: " + key));
        if (currentValue != null) {
            success = true;
        }
        this.storeProperties(properties);
        return success;
    }

    public void updateProperty(String key, String value) {
        Properties properties = this.getProperties();
        properties.setProperty(key, value);
        logger.info((Object)("Updating properties resource: " + this.propertyResourceName + " adding property: " + key + "|" + value));
        this.storeProperties(properties);
    }

    protected String getResourceLocationFromFilesystem() {
        String fileLocation = System.getProperty(this.propertyResourceName);
        String url = null;
        if (fileLocation != null) {
            File file = new File(fileLocation);
            if (file.exists() && file.canRead()) {
                try {
                    url = file.toURL().toExternalForm();
                }
                catch (MalformedURLException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            } else {
                logger.error((Object)("System property: " + this.propertyResourceName + " read but cannot access file: " + fileLocation));
            }
        }
        return url;
    }

    public String getResourceLocationFromClassPath(Class callingClass) {
        URL resource = ClassLoaderUtils.getResource((String)this.propertyResourceName, (Class)callingClass);
        return resource != null ? resource.toExternalForm() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeProperties(Properties properties) {
        OutputStream ostream = null;
        try {
            String crowdFile = URLDecoder.decode(new URL(this.propertyResourceLocation).getFile(), "UTF-8");
            ostream = new FileOutputStream(crowdFile);
            properties.store(ostream, null);
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            if (ostream != null) {
                try {
                    ostream.close();
                }
                catch (IOException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public void setPropertyResourceLocation(String propertyResourceLocation) {
        this.propertyResourceLocation = propertyResourceLocation;
    }

    public void setPropertyResourceName(String propertyResourceName) {
        this.propertyResourceName = propertyResourceName;
    }

    public String getPropertyResourceName() {
        return this.propertyResourceName;
    }

    public String getPropertyResourceLocation() {
        return this.propertyResourceLocation;
    }
}

