/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.service.soap.client;

import com.atlassian.crowd.integration.authentication.PasswordCredential;
import com.atlassian.crowd.integration.authentication.PrincipalAuthenticationContext;
import com.atlassian.crowd.integration.authentication.ValidationFactor;
import com.atlassian.crowd.integration.exception.ApplicationPermissionException;
import com.atlassian.crowd.integration.exception.InactiveAccountException;
import com.atlassian.crowd.integration.exception.InvalidAuthenticationException;
import com.atlassian.crowd.integration.exception.InvalidAuthorizationTokenException;
import com.atlassian.crowd.integration.exception.InvalidCredentialException;
import com.atlassian.crowd.integration.exception.InvalidGroupException;
import com.atlassian.crowd.integration.exception.InvalidPrincipalException;
import com.atlassian.crowd.integration.exception.InvalidRoleException;
import com.atlassian.crowd.integration.exception.InvalidTokenException;
import com.atlassian.crowd.integration.exception.ObjectNotFoundException;
import com.atlassian.crowd.integration.service.soap.client.ClientProperties;
import com.atlassian.crowd.integration.soap.SOAPAttribute;
import com.atlassian.crowd.integration.soap.SOAPGroup;
import com.atlassian.crowd.integration.soap.SOAPPrincipal;
import com.atlassian.crowd.integration.soap.SOAPRole;
import com.atlassian.crowd.integration.soap.SearchRestriction;
import java.rmi.RemoteException;

public interface SecurityServerClient {
    public void authenticate() throws RemoteException, InvalidAuthorizationTokenException;

    public String authenticatePrincipal(PrincipalAuthenticationContext var1) throws RemoteException, InvalidAuthorizationTokenException, InvalidAuthenticationException, InactiveAccountException;

    public boolean isValidToken(String var1, ValidationFactor[] var2) throws RemoteException, InvalidAuthorizationTokenException;

    public void invalidateToken(String var1) throws RemoteException, InvalidAuthorizationTokenException;

    public SOAPGroup[] searchGroups(SearchRestriction[] var1) throws RemoteException, InvalidAuthorizationTokenException;

    public SOAPPrincipal[] searchPrincipals(SearchRestriction[] var1) throws RemoteException, InvalidAuthorizationTokenException;

    public SOAPRole[] searchRoles(SearchRestriction[] var1) throws RemoteException, InvalidAuthorizationTokenException;

    public SOAPGroup[] findAllGroups() throws RemoteException, InvalidAuthorizationTokenException;

    public SOAPRole[] findAllRoles() throws RemoteException, InvalidAuthorizationTokenException;

    public SOAPPrincipal[] findAllPrincipals() throws RemoteException, InvalidAuthorizationTokenException;

    public SOAPGroup addGroup(SOAPGroup var1) throws RemoteException, InvalidGroupException, InvalidAuthorizationTokenException, ApplicationPermissionException;

    public void updateGroup(String var1, String var2, boolean var3) throws RemoteException, ObjectNotFoundException, ApplicationPermissionException, InvalidAuthorizationTokenException;

    public SOAPGroup findGroupByName(String var1) throws RemoteException, InvalidAuthorizationTokenException, ObjectNotFoundException;

    public SOAPRole addRole(SOAPRole var1) throws RemoteException, InvalidAuthorizationTokenException, InvalidRoleException, ApplicationPermissionException;

    public SOAPRole findRoleByName(String var1) throws RemoteException, InvalidAuthorizationTokenException, ObjectNotFoundException;

    public SOAPPrincipal findPrincipalByToken(String var1) throws RemoteException, InvalidTokenException, InvalidAuthorizationTokenException;

    public void updatePrincipalAttribute(String var1, SOAPAttribute var2) throws RemoteException, ObjectNotFoundException, ApplicationPermissionException, InvalidAuthorizationTokenException;

    public SOAPPrincipal findPrincipalByName(String var1) throws RemoteException, InvalidAuthorizationTokenException, ObjectNotFoundException;

    public SOAPPrincipal addPrincipal(SOAPPrincipal var1, PasswordCredential var2) throws RemoteException, InvalidAuthorizationTokenException, InvalidCredentialException, InvalidPrincipalException, ApplicationPermissionException;

    public void addPrincipalToGroup(String var1, String var2) throws RemoteException, InvalidAuthorizationTokenException, ObjectNotFoundException, ApplicationPermissionException;

    public void updatePrincipalCredential(String var1, PasswordCredential var2) throws RemoteException, InvalidAuthorizationTokenException, InvalidCredentialException, ObjectNotFoundException, ApplicationPermissionException;

    public void resetPrincipalCredential(String var1) throws RemoteException, InvalidCredentialException, ObjectNotFoundException, ApplicationPermissionException, InvalidAuthorizationTokenException;

    public void removeGroup(String var1) throws RemoteException, InvalidAuthorizationTokenException, ObjectNotFoundException, ApplicationPermissionException;

    public void removeRole(String var1) throws RemoteException, InvalidAuthorizationTokenException, ObjectNotFoundException, ApplicationPermissionException;

    public void removePrincipal(String var1) throws RemoteException, InvalidAuthorizationTokenException, ObjectNotFoundException, ApplicationPermissionException;

    public void addPrincipalToRole(String var1, String var2) throws RemoteException, InvalidAuthorizationTokenException, ObjectNotFoundException, ApplicationPermissionException;

    public boolean isGroupMember(String var1, String var2) throws RemoteException, InvalidAuthorizationTokenException;

    public boolean isRoleMember(String var1, String var2) throws RemoteException, InvalidAuthorizationTokenException;

    public void removePrincipalFromGroup(String var1, String var2) throws RemoteException, InvalidAuthorizationTokenException, ObjectNotFoundException, ApplicationPermissionException;

    public void removePrincipalFromRole(String var1, String var2) throws RemoteException, InvalidAuthorizationTokenException, ObjectNotFoundException, ApplicationPermissionException;

    public void addAttributeToPrincipal(String var1, SOAPAttribute var2) throws RemoteException, InvalidAuthorizationTokenException, ObjectNotFoundException, ApplicationPermissionException;

    public void removeAttributeFromPrincipal(String var1, String var2) throws RemoteException, InvalidAuthorizationTokenException, ObjectNotFoundException, ApplicationPermissionException;

    public long getCacheTime() throws RemoteException, InvalidAuthorizationTokenException;

    public boolean isCacheEnabled() throws RemoteException, InvalidAuthorizationTokenException;

    public String getDomain() throws RemoteException, InvalidAuthorizationTokenException;

    public String[] findAllPrincipalNames() throws RemoteException, InvalidAuthorizationTokenException;

    public String[] findAllGroupNames() throws RemoteException, InvalidAuthorizationTokenException;

    public String[] findAllRoleNames() throws RemoteException, InvalidAuthorizationTokenException;

    public String[] findGroupMemberships(String var1) throws RemoteException, InvalidAuthorizationTokenException;

    public String[] findRoleMemberships(String var1) throws RemoteException, InvalidAuthorizationTokenException;

    public String authenticatePrincipalSimple(String var1, String var2) throws RemoteException, InvalidAuthorizationTokenException, InvalidAuthenticationException, InactiveAccountException;

    public String createPrincipalToken(String var1, ValidationFactor[] var2) throws RemoteException, InvalidAuthorizationTokenException, InvalidAuthenticationException, InactiveAccountException;

    public ClientProperties getClientProperties();
}

