/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.service.soap.client;

import com.atlassian.crowd.integration.authentication.ApplicationAuthenticationContext;
import com.atlassian.crowd.integration.authentication.PasswordCredential;
import com.atlassian.crowd.util.PropertyUtils;
import java.util.Properties;
import org.apache.log4j.Logger;

public class ClientProperties {
    private static final Logger logger = Logger.getLogger(ClientProperties.class);
    private String applicationName = null;
    private String applicationPassword = null;
    private String applicationAuthenticationURL = null;
    private String securityServerURL = null;
    private String sessionIsAuthenticated = null;
    private String sessionTokenKey = null;
    private String sessionLastValidation = null;
    private long sessionValidationInterval = 0L;
    private ApplicationAuthenticationContext applicationAuthenticationContext = null;
    private final PropertyUtils propertyUtils;

    public ClientProperties(PropertyUtils propertyUtils) {
        this.propertyUtils = propertyUtils;
        Properties properties = propertyUtils.getProperties();
        this.updateProperties(properties);
    }

    public ClientProperties() {
        this(new PropertyUtils());
    }

    public void updateProperties() {
        Properties properties = this.propertyUtils.getProperties();
        this.updateProperties(properties);
    }

    public void updateProperties(Properties properties) {
        this.applicationName = this.loadPropertyString(properties, "application.name", true);
        this.applicationPassword = this.loadPropertyString(properties, "application.password", false);
        this.applicationAuthenticationURL = this.loadPropertyString(properties, "application.login.url", true);
        this.securityServerURL = this.loadPropertyString(properties, "crowd.server.url", true);
        this.sessionIsAuthenticated = this.loadPropertyString(properties, "session.isauthenticated", true);
        this.sessionTokenKey = this.loadPropertyString(properties, "session.tokenkey", true);
        this.sessionLastValidation = this.loadPropertyString(properties, "session.lastvalidation", true);
        this.sessionValidationInterval = this.loadPropertyLong(properties, "session.validationinterval", true);
        PasswordCredential credentials = new PasswordCredential();
        credentials.setCredential(this.applicationPassword);
        this.applicationAuthenticationContext = new ApplicationAuthenticationContext();
        this.applicationAuthenticationContext.setName(this.applicationName);
        this.applicationAuthenticationContext.setCredential(credentials);
    }

    private long loadPropertyLong(Properties properties, String propertyName, boolean logProperty) {
        long propertyValue = 0L;
        String propertyValueAsString = this.loadPropertyString(properties, propertyName, logProperty);
        if (propertyValueAsString != null) {
            propertyValue = Long.parseLong(propertyValueAsString);
        }
        return propertyValue;
    }

    private String loadPropertyString(Properties properties, String propertyName, boolean logProperty) {
        String propertyValue = null;
        if (properties != null && properties.containsKey(propertyName)) {
            propertyValue = properties.getProperty(propertyName);
            if (logger.isDebugEnabled() && logProperty) {
                logger.debug((Object)("Loading property: '" + propertyName + "' : '" + propertyValue + "'"));
            }
        } else {
            logger.fatal((Object)("Failed to value for property: " + propertyName));
        }
        return propertyValue;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public String getApplicationPassword() {
        return this.applicationPassword;
    }

    public String getApplicationAuthenticationURL() {
        return this.applicationAuthenticationURL;
    }

    public String getSecurityServerURL() {
        return this.securityServerURL;
    }

    public String getSessionIsAuthenticated() {
        return this.sessionIsAuthenticated;
    }

    public String getSessionTokenKey() {
        return this.sessionTokenKey;
    }

    public String getSessionLastValidation() {
        return this.sessionLastValidation;
    }

    public long getSessionValidationInterval() {
        return this.sessionValidationInterval;
    }

    public ApplicationAuthenticationContext getApplicationAuthenticationContext() {
        return this.applicationAuthenticationContext;
    }
}

