/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.seraph;

import com.atlassian.crowd.integration.http.HttpAuthenticator;
import com.atlassian.crowd.integration.service.soap.client.SecurityServerClient;
import com.atlassian.crowd.integration.soap.SOAPPrincipal;
import com.atlassian.seraph.auth.AuthenticatorException;
import com.atlassian.seraph.auth.DefaultAuthenticator;
import com.atlassian.seraph.cookie.CookieFactory;
import com.atlassian.seraph.util.RedirectUtils;
import java.security.Principal;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;

public abstract class CrowdAuthenticator
extends DefaultAuthenticator {
    private static final Logger logger = Logger.getLogger(CrowdAuthenticator.class);
    protected final SecurityServerClient securityServerClient;
    protected final HttpAuthenticator httpAuthenticator;

    public CrowdAuthenticator(SecurityServerClient securityServerClient, HttpAuthenticator httpAuthenticator) {
        this.securityServerClient = securityServerClient;
        this.httpAuthenticator = httpAuthenticator;
    }

    protected boolean authenticate(Principal user, String password) {
        return true;
    }

    public boolean login(HttpServletRequest request, HttpServletResponse response, String username, String password, boolean cookie) throws AuthenticatorException {
        try {
            this.logout(request, response);
            logger.debug((Object)"Authenticating user with Crowd");
            this.httpAuthenticator.authenticate(request, response, username, password);
            logger.debug((Object)"Updating user session for Seraph");
            return super.login(request, response, username, password, cookie);
        }
        catch (Exception e) {
            logger.info((Object)e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public boolean login(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String username, String password) throws AuthenticatorException {
        return this.login(httpServletRequest, httpServletResponse, username, password, false);
    }

    public boolean logout(HttpServletRequest request, HttpServletResponse response) throws AuthenticatorException {
        try {
            logger.debug((Object)"Logging off from Crowd");
            this.httpAuthenticator.logoff(request, response);
            logger.debug((Object)"Invalidating user in Crowd-Seraph specific session variables");
            this.logoutUser(request);
        }
        catch (Exception e) {
            logger.info((Object)e.getMessage(), (Throwable)e);
        }
        logger.debug((Object)"Invalidating user in Seraph specific session variables");
        return super.logout(request, response);
    }

    protected boolean isAuthenticated(HttpServletRequest request, HttpServletResponse response) {
        Principal basicAuthUser;
        boolean authenticated = false;
        if ("success".equals(request.getAttribute("os_authstatus"))) {
            authenticated = true;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"User IS authenticated via previous filter");
            }
        }
        if (!authenticated) {
            try {
                authenticated = this.httpAuthenticator.isAuthenticated(request, response);
                if (authenticated && logger.isDebugEnabled()) {
                    logger.debug((Object)"User IS authenticated via the Crowd session-token");
                } else if (logger.isDebugEnabled()) {
                    logger.debug((Object)"User is NOT authenticated via the Crowd session-token");
                }
            }
            catch (Exception e) {
                logger.info((Object)"Error while attempting to check if user isAuthenticated with Crowd", (Throwable)e);
            }
        }
        if (!authenticated) {
            authenticated = this.autoLoginToCrowd(request, response);
            if (authenticated && logger.isDebugEnabled()) {
                logger.debug((Object)"Authenticated via Crowd-Seraph AutoLogin cookie");
            } else if (logger.isDebugEnabled()) {
                logger.debug((Object)"Failed to authenticate via Crowd-Seraph AutoLogin cookie");
            }
        }
        if (!authenticated && RedirectUtils.isBasicAuthentication((HttpServletRequest)request, (String)this.getAuthType()) && (basicAuthUser = this.getUserFromBasicAuthentication(request, response)) != null) {
            authenticated = true;
        }
        if (!authenticated) {
            logger.debug((Object)"Request is not authenticated, logging out the user");
            try {
                this.logoutUser(request);
                if (response != null) {
                    super.logout(request, response);
                }
            }
            catch (AuthenticatorException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            authenticated = false;
        }
        return authenticated;
    }

    protected boolean autoLoginToCrowd(HttpServletRequest request, HttpServletResponse response) {
        Cookie cookie = CookieFactory.getCookieHandler().getCookie(request, this.getLoginCookieKey());
        if (cookie == null) {
            return false;
        }
        String[] values = this.decodeCookie(cookie.getValue());
        if (values == null) {
            return false;
        }
        String username = values[0];
        String password = values[1];
        logger.debug((Object)"Got username and password from autologin cookie, attempting to authenticate user");
        try {
            this.httpAuthenticator.authenticate(request, response, username, password);
            logger.debug((Object)"User authenticated via autologin cookie");
            return true;
        }
        catch (Exception e) {
            logger.debug((Object)("Could not autologin authenticate user " + username), (Throwable)e);
            if (response != null) {
                CookieFactory.getCookieHandler().invalidateCookie(request, response, this.getLoginCookieKey(), "/");
            }
            return false;
        }
    }

    abstract void logoutUser(HttpServletRequest var1);

    public Principal getUser(HttpServletRequest request, HttpServletResponse response) {
        Principal user = null;
        if (this.isAuthenticated(request, response) && (user = this.getUserFromSession(request)) == null) {
            try {
                String token = this.httpAuthenticator.getToken(request);
                SOAPPrincipal soapPrincipal = this.securityServerClient.findPrincipalByToken(token);
                user = this.getUser(soapPrincipal.getName());
            }
            catch (Exception e) {
                logger.info((Object)e.getMessage(), (Throwable)e);
            }
            HttpSession session = request.getSession();
            session.setAttribute(LOGGED_IN_KEY, (Object)user);
            session.setAttribute(LOGGED_OUT_KEY, null);
        }
        return user;
    }
}

