/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.osuser;

import com.atlassian.crowd.integration.authentication.PasswordCredential;
import com.atlassian.crowd.integration.authentication.PrincipalAuthenticationContext;
import com.atlassian.crowd.integration.http.HttpAuthenticator;
import com.atlassian.crowd.integration.http.HttpAuthenticatorFactory;
import com.atlassian.crowd.integration.osuser.CrowdBaseProvider;
import com.atlassian.crowd.integration.service.soap.client.SecurityServerClient;
import com.atlassian.crowd.integration.service.soap.client.SecurityServerClientFactory;
import com.atlassian.crowd.integration.soap.SOAPPrincipal;
import com.opensymphony.user.Entity;
import com.opensymphony.user.provider.CredentialsProvider;
import java.util.List;

public class CrowdCredentialsProvider
extends CrowdBaseProvider
implements CredentialsProvider {
    public CrowdCredentialsProvider() {
        this(SecurityServerClientFactory.getSecurityServerClient(), HttpAuthenticatorFactory.getHttpAuthenticator());
    }

    public CrowdCredentialsProvider(SecurityServerClient securityServerClient, HttpAuthenticator httpAuthenticator) {
        super(securityServerClient, httpAuthenticator);
    }

    public boolean authenticate(String name, String password) {
        boolean authenticated = false;
        try {
            PrincipalAuthenticationContext authenticationContext = this.httpAuthenticator.getPrincipalAuthenticationContext(null, null, name, password);
            this.securityServerClient.authenticatePrincipal(authenticationContext);
            authenticated = true;
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return authenticated;
    }

    public boolean changePassword(String name, String password) {
        boolean success = false;
        try {
            PasswordCredential credential = new PasswordCredential(password);
            this.securityServerClient.updatePrincipalCredential(name, credential);
            success = true;
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return success;
    }

    public boolean create(String username) {
        boolean success = false;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Creating user: " + username));
        }
        SOAPPrincipal principal = new SOAPPrincipal();
        principal.setActive(true);
        principal.setName(username);
        try {
            this.securityServerClient.addPrincipal(principal, null);
            this.flushCaches();
            success = true;
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return success;
    }

    public boolean handles(String username) {
        boolean success = false;
        if (this.findPrincipalByName(username) != null) {
            success = true;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Do we handle " + username + " ? " + success));
        }
        return success;
    }

    public List list() {
        return this.findPrincipalNames();
    }

    public boolean load(String name, Entity.Accessor accessor) {
        SOAPPrincipal user;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("load : name = " + name));
        }
        if ((user = this.findPrincipalByName(name)) != null) {
            accessor.setName(user.getName());
            accessor.setMutable(true);
            return true;
        }
        return false;
    }

    public boolean remove(String username) {
        boolean success = false;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("load : name = " + username));
        }
        try {
            this.securityServerClient.removePrincipal(username);
            success = true;
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return success;
    }

    public boolean store(String string, Entity.Accessor accessor) {
        return true;
    }
}

