/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.osuser;

import com.atlassian.crowd.integration.cache.CacheManager;
import com.atlassian.crowd.integration.cache.CacheManagerFactory;
import com.atlassian.crowd.integration.cache.CacheManagerImpl;
import com.atlassian.crowd.integration.exception.ObjectNotFoundException;
import com.atlassian.crowd.integration.http.HttpAuthenticator;
import com.atlassian.crowd.integration.service.soap.client.SecurityServerClient;
import com.atlassian.crowd.integration.soap.SOAPPrincipal;
import com.opensymphony.user.Entity;
import com.opensymphony.user.provider.UserProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import net.sf.ehcache.CacheException;
import org.apache.log4j.Logger;

public abstract class CrowdBaseProvider
implements UserProvider {
    protected final Logger logger = Logger.getLogger(this.getClass());
    protected CacheManagerFactory cacheManagerFactory;
    protected final SecurityServerClient securityServerClient;
    protected final HttpAuthenticator httpAuthenticator;

    protected CrowdBaseProvider(SecurityServerClient securityServerClient, HttpAuthenticator httpAuthenticator) {
        this.cacheManagerFactory = new CacheManagerFactory(){

            public CacheManager getCacheManager() {
                return CacheManagerImpl.getInstance();
            }
        };
        this.securityServerClient = securityServerClient;
        this.httpAuthenticator = httpAuthenticator;
    }

    protected CrowdBaseProvider(CacheManagerFactory cacheManagerFactory, SecurityServerClient securityServerClient, HttpAuthenticator httpAuthenticator) {
        this.cacheManagerFactory = cacheManagerFactory;
        this.securityServerClient = securityServerClient;
        this.httpAuthenticator = httpAuthenticator;
    }

    protected CacheManager getCacheManager() {
        return this.cacheManagerFactory.getCacheManager();
    }

    protected SOAPPrincipal findPrincipalByName(String username) {
        SOAPPrincipal principal = null;
        if (this.getCacheManager().isCacheEnabled()) {
            try {
                principal = this.getCacheManager().getPrincipal(username);
            }
            catch (CacheException e) {
                // empty catch block
            }
        }
        if (principal == null) {
            try {
                principal = this.securityServerClient.findPrincipalByName(username);
                if (this.getCacheManager().isCacheEnabled() && principal != null) {
                    this.getCacheManager().cachePrincipal(principal);
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Found principal: " + principal.toString()));
                }
            }
            catch (ObjectNotFoundException oe) {
                this.logger.error((Object)("Failed to find user: " + username));
            }
            catch (Exception e) {
                this.logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return principal;
    }

    protected List findPrincipalNames() {
        if (this.getCacheManager().isCacheEnabled()) {
            try {
                return this.getCacheManager().getPrincipalNames();
            }
            catch (CacheException e) {
                // empty catch block
            }
        }
        List<Object> principalNames = new ArrayList();
        try {
            principalNames = Arrays.asList(this.securityServerClient.findAllPrincipalNames());
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
        if (this.getCacheManager().isCacheEnabled()) {
            this.getCacheManager().cachePrincipalNames(principalNames);
        }
        return principalNames;
    }

    protected List findAllGroupNames() {
        if (this.getCacheManager().isCacheEnabled()) {
            try {
                return this.getCacheManager().getGroupNames();
            }
            catch (CacheException e) {
                // empty catch block
            }
        }
        List<String> groupNames = null;
        try {
            groupNames = Arrays.asList(this.securityServerClient.findAllGroupNames());
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
        if (this.getCacheManager().isCacheEnabled()) {
            this.getCacheManager().cacheGroupNames(groupNames);
        }
        return groupNames;
    }

    public boolean handles(String name) {
        SOAPPrincipal soapPrincipal = this.findPrincipalByName(name);
        return soapPrincipal != null;
    }

    public boolean init(Properties properties) {
        return true;
    }

    public void flushCaches() {
        if (this.getCacheManager().isCacheEnabled()) {
            this.getCacheManager().flushCaches();
        }
    }

    public List list() {
        return this.findPrincipalNames();
    }

    public boolean create(String name) {
        return true;
    }

    public boolean remove(String name) {
        return false;
    }

    public boolean store(String name, Entity.Accessor accessor) {
        return false;
    }

    public boolean load(String string, Entity.Accessor accessor) {
        accessor.setMutable(true);
        return true;
    }
}

