/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.jive;

import com.atlassian.crowd.integration.authentication.PasswordCredential;
import com.atlassian.crowd.integration.exception.ApplicationPermissionException;
import com.atlassian.crowd.integration.exception.InvalidAuthorizationTokenException;
import com.atlassian.crowd.integration.exception.InvalidCredentialException;
import com.atlassian.crowd.integration.exception.InvalidPrincipalException;
import com.atlassian.crowd.integration.exception.ObjectNotFoundException;
import com.atlassian.crowd.integration.jive.CrowdUser;
import com.atlassian.crowd.integration.service.soap.client.SecurityServerClient;
import com.atlassian.crowd.integration.service.soap.client.SecurityServerClientFactory;
import com.atlassian.crowd.integration.soap.SOAPAttribute;
import com.atlassian.crowd.integration.soap.SOAPPrincipal;
import com.atlassian.crowd.integration.soap.SearchRestriction;
import com.jivesoftware.base.AdvancedUserManager;
import com.jivesoftware.base.IntrospectiveUserManager;
import com.jivesoftware.base.JiveEvent;
import com.jivesoftware.base.UnauthorizedException;
import com.jivesoftware.base.User;
import com.jivesoftware.base.UserAlreadyExistsException;
import com.jivesoftware.base.UserManagerFactory;
import com.jivesoftware.base.UserNotFoundException;
import com.jivesoftware.base.database.ConnectionManager;
import com.jivesoftware.base.database.UserIterator;
import com.jivesoftware.base.event.UserEvent;
import com.jivesoftware.base.event.UserEventDispatcher;
import com.jivesoftware.util.Cache;
import com.jivesoftware.util.CacheFactory;
import com.jivesoftware.util.LongList;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;

public class CrowdUserManager
implements IntrospectiveUserManager,
AdvancedUserManager {
    private static final Logger LOGGER = Logger.getLogger(CrowdUserManager.class);
    private static final String DELETE_USER_GROUPS = "DELETE FROM jiveGroupUser WHERE userID=?";
    private static final String DELETE_USER_PROPS = "DELETE FROM jiveUserProp WHERE userID=?";
    private static final String DELETE_USER_WATCHES = "DELETE FROM jiveWatch WHERE userID=?";
    private static final String DELETE_USER = "DELETE FROM jiveUser WHERE userID=?";
    private static final String USER_COUNT = "SELECT count(*) FROM jiveUser";
    private static final String ALL_USERS = "SELECT userID from jiveUser";
    private static Cache userEmailCache;
    private final SecurityServerClient securityServerClient;

    public CrowdUserManager() {
        this(SecurityServerClientFactory.getSecurityServerClient());
    }

    public CrowdUserManager(SecurityServerClient securityServerClient) {
        this.securityServerClient = securityServerClient;
        userEmailCache = CacheFactory.createCache((String)"User Email Map");
        LOGGER.debug((Object)("Do we have a user email cache? " + userEmailCache.getName()));
    }

    public User createUser(String username, String password, String email) throws UserAlreadyExistsException {
        User user = null;
        try {
            try {
                this.securityServerClient.findPrincipalByName(username);
                throw new UserAlreadyExistsException(username);
            }
            catch (ObjectNotFoundException e) {
                SOAPPrincipal principal = new SOAPPrincipal();
                principal.setActive(true);
                principal.setName(username);
                SOAPAttribute[] soapAttributes = new SOAPAttribute[]{this.buildAttribute("mail", email), this.buildAttribute("givenName", ""), this.buildAttribute("sn", "")};
                principal.setAttributes(soapAttributes);
                PasswordCredential credentials = new PasswordCredential();
                credentials.setCredential(password);
                this.securityServerClient.addPrincipal(principal, credentials);
                user = this.getUser(username);
            }
        }
        catch (RemoteException e) {
            LOGGER.error((Object)e);
            throw new UnsupportedOperationException(e);
        }
        catch (InvalidAuthorizationTokenException e) {
            LOGGER.error((Object)e);
            throw new UnsupportedOperationException(e);
        }
        catch (InvalidCredentialException e) {
            LOGGER.error((Object)e);
            throw new UnsupportedOperationException(e);
        }
        catch (InvalidPrincipalException e) {
            LOGGER.error((Object)e);
            throw new UnsupportedOperationException(e);
        }
        catch (ApplicationPermissionException e) {
            LOGGER.error((Object)e);
            throw new UnsupportedOperationException(e);
        }
        catch (UserNotFoundException e) {
            LOGGER.error((Object)e);
            throw new UnsupportedOperationException(e);
        }
        return user;
    }

    public User createUser(String username, String password, String name, String email, boolean nameVisible, boolean emailVisible, Map properties) throws UserAlreadyExistsException {
        User user = this.createUser(username, password, email);
        user.setEmailVisible(emailVisible);
        user.setNameVisible(nameVisible);
        for (String propName : properties.keySet()) {
            String propValue = (String)properties.get(propName);
            user.setProperty(propName, propValue);
        }
        return user;
    }

    public User getUser(long userID) throws UserNotFoundException {
        Object user;
        boolean debug = LOGGER.isDebugEnabled();
        if (debug) {
            LOGGER.debug((Object)("In CrowdUserManger.getUser(" + userID + ")"));
        }
        if ((user = (User)UserManagerFactory.userCache.get((Object)new Long(userID))) == null) {
            if (debug) {
                LOGGER.debug((Object)("In CrowdUserManger.getUser(" + userID + "), getting Crowd user"));
            }
            user = new CrowdUser(userID, null);
            if (debug) {
                LOGGER.debug((Object)("In CrowdUserManger.getUser(" + userID + "), user retrieved"));
            }
            UserManagerFactory.userCache.put((Object)new Long(userID), user);
            if (user.getEmail() != null) {
                userEmailCache.put((Object)user.getEmail().trim().toLowerCase(), (Object)new Long(user.getID()));
            }
        }
        return user;
    }

    public User getUser(String username) throws UserNotFoundException {
        boolean debug = LOGGER.isDebugEnabled();
        if (debug) {
            LOGGER.debug((Object)("In CrowdUserManger.getUser(" + username + ")"));
        }
        try {
            if (debug) {
                LOGGER.debug((Object)("In CrowdUserManger.getUser(" + username + "), getting User"));
            }
            return this.getUser(this.getUserID(username));
        }
        catch (UserNotFoundException ue) {
            if (debug) {
                LOGGER.debug((Object)("In CrowdUserManger.getUser(" + username + "), user not found in db, creating Crowd user"));
            }
            return new CrowdUser(username);
        }
    }

    public long getUserID(String username) throws UserNotFoundException {
        Long userIDLong;
        boolean debug = LOGGER.isDebugEnabled();
        if (debug) {
            LOGGER.debug((Object)("In CrowdUserManger.getUserID(" + username + ")"));
        }
        if ((userIDLong = (Long)UserManagerFactory.userIDCache.get((Object)username)) == null) {
            CrowdUser user = new CrowdUser(username, null);
            userIDLong = new Long(user.getID());
            UserManagerFactory.userIDCache.put((Object)username, (Object)userIDLong);
        }
        if (debug) {
            LOGGER.debug((Object)("In CrowdUserManger.getUser(" + username + "), userID was " + userIDLong));
        }
        return userIDLong;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteUser(User user) throws UnauthorizedException {
        boolean debug = LOGGER.isDebugEnabled();
        if (user == null) {
            throw new IllegalArgumentException("User cannot be null");
        }
        if (debug) {
            LOGGER.debug((Object)("In CrowdUserManger.deleteUser(" + user.getUsername() + ")"));
        }
        long userID = user.getID();
        UserEvent event = new UserEvent(11, user, Collections.EMPTY_MAP);
        UserManagerFactory.dispatchEvent((JiveEvent)event);
        if (event.getFailureException() != null) {
            LOGGER.error((Object)event.getFailureException());
            return;
        }
        Connection con = null;
        PreparedStatement pstmt = null;
        boolean abortTransaction = false;
        try {
            con = ConnectionManager.getTransactionConnection();
            pstmt = con.prepareStatement(DELETE_USER_GROUPS);
            pstmt.setLong(1, userID);
            pstmt.execute();
            pstmt.close();
            pstmt = con.prepareStatement(DELETE_USER_PROPS);
            pstmt.setLong(1, userID);
            pstmt.execute();
            pstmt.close();
            pstmt = con.prepareStatement(DELETE_USER_WATCHES);
            pstmt.setLong(1, userID);
            pstmt.execute();
            pstmt.close();
            pstmt = con.prepareStatement(DELETE_USER);
            pstmt.setLong(1, userID);
            pstmt.execute();
        }
        catch (Exception e) {
            if (debug) {
                LOGGER.debug((Object)("In CrowdUserManger.deleteUser(" + user.getUsername() + "), exception thrown"), (Throwable)e);
            }
            LOGGER.error((Object)e);
            abortTransaction = true;
        }
        finally {
            ConnectionManager.closeTransactionConnection((PreparedStatement)pstmt, (Connection)con, (boolean)abortTransaction);
        }
        UserManagerFactory.userCache.remove((Object)new Long(userID));
        UserManagerFactory.userIDCache.remove((Object)user.getUsername());
        if (user.getEmail() != null) {
            userEmailCache.remove((Object)user.getEmail().trim().toLowerCase());
        }
        UserEventDispatcher.getInstance().dispatchEvent(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getUserCount() {
        int count = 0;
        Connection con = null;
        PreparedStatement pstmt = null;
        try {
            con = ConnectionManager.getConnection();
            pstmt = con.prepareStatement(USER_COUNT);
            ResultSet rs = pstmt.executeQuery();
            rs.next();
            count = rs.getInt(1);
            rs.close();
        }
        catch (SQLException sqle) {
            try {
                LOGGER.error((Object)sqle);
            }
            catch (Throwable throwable) {
                ConnectionManager.closeConnection(pstmt, (Connection)con);
                throw throwable;
            }
            ConnectionManager.closeConnection((PreparedStatement)pstmt, (Connection)con);
        }
        ConnectionManager.closeConnection((PreparedStatement)pstmt, (Connection)con);
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator users() {
        LongList users = new LongList(500);
        Connection con = null;
        PreparedStatement pstmt = null;
        try {
            con = ConnectionManager.getConnection();
            pstmt = con.prepareStatement(ALL_USERS);
            ResultSet rs = pstmt.executeQuery();
            ConnectionManager.setFetchSize((ResultSet)rs, (int)500);
            while (rs.next()) {
                users.add(rs.getLong(1));
            }
            rs.close();
        }
        catch (SQLException e) {
            try {
                LOGGER.error((Object)e);
            }
            catch (Throwable throwable) {
                ConnectionManager.closeConnection(pstmt, (Connection)con);
                throw throwable;
            }
            ConnectionManager.closeConnection((PreparedStatement)pstmt, (Connection)con);
        }
        ConnectionManager.closeConnection((PreparedStatement)pstmt, (Connection)con);
        return new UserIterator(users.toArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator users(int startIndex, int numResults) {
        LongList users = new LongList();
        Connection con = null;
        PreparedStatement pstmt = null;
        try {
            int i;
            con = ConnectionManager.getConnection();
            pstmt = con.prepareStatement(ALL_USERS);
            ResultSet rs = pstmt.executeQuery();
            ConnectionManager.setFetchSize((ResultSet)rs, (int)(startIndex + numResults));
            for (i = 0; i < startIndex; ++i) {
                rs.next();
            }
            for (i = 0; i < numResults && rs.next(); ++i) {
                users.add(rs.getLong(1));
            }
            rs.close();
        }
        catch (SQLException e) {
            try {
                LOGGER.error((Object)e);
            }
            catch (Throwable throwable) {
                ConnectionManager.closeConnection(pstmt, (Connection)con);
                throw throwable;
            }
            ConnectionManager.closeConnection((PreparedStatement)pstmt, (Connection)con);
        }
        ConnectionManager.closeConnection((PreparedStatement)pstmt, (Connection)con);
        return new UserIterator(users.toArray());
    }

    public SOAPAttribute buildAttribute(String key, String value) {
        SOAPAttribute attribute = new SOAPAttribute();
        attribute.setName(key);
        attribute.setValues(new String[1]);
        attribute.getValues()[0] = value;
        return attribute;
    }

    public User getUserFromEmailAddress(String email) {
        if (email == null) {
            return null;
        }
        String trimmedEmail = email.trim().toLowerCase();
        Long userID = (Long)userEmailCache.get((Object)trimmedEmail);
        if (userID == null) {
            try {
                SearchRestriction[] searchRestrictions = new SearchRestriction[]{new SearchRestriction()};
                searchRestrictions[0].setName("principal.email");
                searchRestrictions[0].setValue(email);
                SOAPPrincipal[] soapPrincipals = this.securityServerClient.searchPrincipals(searchRestrictions);
                if (soapPrincipals.length > 0) {
                    String username = soapPrincipals[0].getName();
                    User user = this.getUser(username);
                    userEmailCache.put((Object)trimmedEmail, (Object)new Long(user.getID()));
                    return user;
                }
                userEmailCache.put((Object)trimmedEmail, (Object)new Long(-1L));
            }
            catch (Exception e) {
                LOGGER.error((Object)e);
            }
        } else {
            if (userID == -1L) {
                return null;
            }
            try {
                return this.getUser(userID);
            }
            catch (UserNotFoundException e) {
                LOGGER.error((Object)e);
            }
        }
        return null;
    }

    public Iterator getUsersFromEmailAddress(String string) {
        User user = this.getUserFromEmailAddress(string);
        if (user == null) {
            Iterator iterator = Collections.EMPTY_LIST.iterator();
        }
        ArrayList<User> users = new ArrayList<User>(1);
        users.add(user);
        Iterator iterator = users.iterator();
        return iterator;
    }

    public boolean isCreateUserSupported() {
        return false;
    }

    public boolean isDeleteUserSupported() {
        return true;
    }

    public boolean isGetUserCountSupported() {
        return true;
    }

    public boolean isUserListSupported() {
        return true;
    }

    public boolean isGetUserFromEmailAddressSupported() {
        return true;
    }

    public boolean isReadOnly() {
        return false;
    }
}

